'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.11.1/tcllib-1.11.1/modules/pop3d/pop3d.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pop3d" n 1.1.0 pop3d "Tcl POP3 Server Package"
.BS
.SH NAME
pop3d \- Tcl POP3 server implementation
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBpop3d  ?1.1.0?\fR
.sp
\fB::pop3d::new\fR ?\fIserverName\fR?
.sp
\fBserverName\fR \fIoption\fR ?\fIarg arg ...\fR?
.sp
\fIserverName\fR \fBup\fR
.sp
\fIserverName\fR \fBdown\fR
.sp
\fIserverName\fR \fBdestroy\fR ?\fImode\fR?
.sp
\fIserverName\fR \fBconfigure\fR
.sp
\fIserverName\fR \fBconfigure\fR \fI-option\fR
.sp
\fIserverName\fR \fBconfigure\fR \fI-option value\fR...
.sp
\fIserverName\fR \fBcget\fR \fI-option\fR
.sp
\fIserverName\fR \fBconn\fR list
.sp
\fIserverName\fR \fBconn\fR state \fIid\fR
.sp
\fIauthCmd\fR \fBexists\fR \fIname\fR
.sp
\fIauthCmd\fR \fBlookup\fR \fIname\fR
.sp
\fIstorageCmd\fR \fBdele\fR \fImbox\fR \fImsgList\fR
.sp
\fIstorageCmd\fR \fBlock\fR \fImbox\fR
.sp
\fIstorageCmd\fR \fBunlock\fR \fImbox\fR
.sp
\fIstorageCmd\fR \fBsize\fR \fImbox\fR ?\fImsgId\fR?
.sp
\fIstorageCmd\fR \fBstat\fR \fImbox\fR
.sp
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR
.sp
.BE
.SH DESCRIPTION
.PP
.TP
\fB::pop3d::new\fR ?\fIserverName\fR?
This command creates a new server object with an associated global Tcl
command whose name is \fIserverName\fR.
.PP
The command \fBserverName\fR may be used to invoke various operations
on the server.  It has the following general form:
.TP
\fBserverName\fR \fIoption\fR ?\fIarg arg ...\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
.PP
A pop3 server can be started on any port the caller has permission for
from the operating system. The default port will be 110, which is the
port defined by the standard specified in
RFC 1939 (\fIhttp://www.rfc-editor.org/rfc/rfc1939.txt\fR).
After creating, configuring and starting a the server object will
listen for and accept connections on that port and handle them
according to the POP3 protocol.
.PP
\fINote:\fR The server provided by this module will handle only the
basic protocol by itself. For the higher levels of user authentication
and handling of the actual mailbox contents callbacks will be invoked.
.PP
The following commands are possible for server objects:
.TP
\fIserverName\fR \fBup\fR
After this call the server will listen for connections on its configured port.
.TP
\fIserverName\fR \fBdown\fR
After this call the server will stop listening for connections. This
does not affect existing connections.
.TP
\fIserverName\fR \fBdestroy\fR ?\fImode\fR?
Destroys the server object. Currently open connections are handled
depending on the chosen mode.
The provided \fImode\fRs are:
.RS
.TP
\fBkill\fR
Destroys the server immediately, and forcefully closes all currently
open connections. This is the default mode.
.TP
\fBdefer\fR
Stops the server from accepting new connections and will actually
destroy it only after the last of the currently open connections for
the server is closed.
.RE
.TP
\fIserverName\fR \fBconfigure\fR
Returns a list containing all options and their current values in a
format suitable for use by the command \fBarray set\fR. The options
themselves are described in section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBconfigure\fR \fI-option\fR
Returns the current value of the specified option. This is an alias
for the method \fBcget\fR. The options themselves are described in
section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBconfigure\fR \fI-option value\fR...
Sets the specified option to the provided value. The options
themselves are described in section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBcget\fR \fI-option\fR
Returns the current value of the specified option. The options
themselves are described in section \fBOPTIONS\fR.
.TP
\fIserverName\fR \fBconn\fR list
Returns a list containing the ids of all connections currently open.
.TP
\fIserverName\fR \fBconn\fR state \fIid\fR
Returns a list suitable for [\fBarray set\fR] containing the
state of the connection referenced by \fIid\fR.
.PP
.SH OPTIONS
The following options are available to pop3 server objects.
.TP
\fB-port\fR \fIport\fR
Defines the \fIport\fR to listen on for new connections. Default is
110. This option is a bit special. If \fIport\fR is set to "0" the
server, or rather the operating system, will select a free port on its
own. When querying \fB-port\fR the id of this chosen port will be
returned. Changing the port while the server is up will neither change
the returned value, nor will it change on which port the server is
listening on. Only after resetting the server via a call to
\fBdown\fR followed by a call to \fBup\fR will the new port take
effect. It is at that time that the value returned when querying
\fB-port\fR will change too.
.TP
\fB-auth\fR \fIcommand\fR
Defines a \fIcommand\fR prefix to call whenever the authentication of
a user is required. If no such command is specified the server will
reject all users. The interface which has to be provided by the
command prefix is described in section \fBAUTHENTICATION\fR.
.TP
\fB-storage\fR \fIcommand\fR
Defines a \fIcommand\fR prefix to call whenever the handling of
mailbox contents is required. If no such command is specified the
server will claim that all mailboxes are empty. The interface which
has to be provided by the command prefix is described in section
\fBMAILBOXES\fR.
.TP
\fB-socket\fR \fIcommand\fR
Defines a \fIcommand\fR prefix to call for opening the listening socket.
This can be used to make the pop3 server listen on a SSL socket
as provided by the tls package.
.PP
.SH AUTHENTICATION
Here we describe the interface which has to be provided by the
authentication callback so that pop3 servers following the interface
of this module are able to use it.
.TP
\fIauthCmd\fR \fBexists\fR \fIname\fR
This method is given a user\fIname\fR and has to return a boolean
value telling whether or not the specified user exists.
.TP
\fIauthCmd\fR \fBlookup\fR \fIname\fR
This method is given a user\fIname\fR and has to return a two-element
list containing the password for this user and a storage reference, in
this order.
.sp
The storage reference is passed unchanged to the storage callback, see
sections \fBOPTIONS\fR and \fBMAILBOXES\fR for either the
option defining it and or the interface to provide, respectively.
.PP
.SH MAILBOXES
Here we describe the interface which has to be provided by the storage
callback so that pop3 servers following the interface of this module
are able to use it. The \fImbox\fR argument is the storage reference
as returned by the \fBlookup\fR method of the authentication
command, see section \fBAUTHENTICATION\fR.
.TP
\fIstorageCmd\fR \fBdele\fR \fImbox\fR \fImsgList\fR
]
Deletes the messages whose numeric ids are contained in the
\fImsgList\fR from the mailbox specified via \fImbox\fR.
.TP
\fIstorageCmd\fR \fBlock\fR \fImbox\fR
This method locks the specified mailbox for use by a single connection
to the server. This is necessary to prevent havoc if several
connections to the same mailbox are open. The complementary method is
\fBunlock\fR. The command will return true if the lock could be set
successfully or false if not.
.TP
\fIstorageCmd\fR \fBunlock\fR \fImbox\fR
This is the complementary method to \fBlock\fR, it revokes the lock
on the specified mailbox.
.TP
\fIstorageCmd\fR \fBsize\fR \fImbox\fR ?\fImsgId\fR?
Determines the size of the message specified through its id in
\fImsgId\fR, in bytes, and returns this number. The command will
return the size of the whole maildrop if no message id was specified.
.TP
\fIstorageCmd\fR \fBstat\fR \fImbox\fR
Determines the number of messages in the specified mailbox and returns
this number.
.TP
\fIstorageCmd\fR \fBget\fR \fImbox\fR \fImsgId\fR
Returns a handle for the specified message. This handle is a mime
token following the interface described in the documentation of
package \fBmime\fR. The pop3 server will use the functionality of
the mime token to send the mail to the requestor at the other end of a
pop3 connection.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIpop3d\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
internet, network, pop3, protocol, rfc 1939
.SH COPYRIGHT
.nf
Copyright (c) 2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi