/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.jdbc;

import ca.sqlpower.architect.jdbc.OracleConnectionDecorator;
import ca.sqlpower.architect.jdbc.PostgresConnectionDecorator;
import ca.sqlpower.architect.jdbc.StatementDecorator;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConnectionDecorator
implements Connection {
    private static Logger logger = Logger.getLogger(ConnectionDecorator.class);
    private int openStatementCount;
    private Connection connection;

    protected ConnectionDecorator(Connection delegate) {
        this.connection = delegate;
    }

    public static ConnectionDecorator createFacade(Connection delegate) throws SQLException {
        logger.debug((Object)("static createFacade, driver class is: " + delegate.getClass().getName()));
        logger.debug((Object)("static createFacade, driver name is: " + delegate.getMetaData().getDriverName()));
        if (delegate.getMetaData().getDriverName().equals("PostgreSQL Native Driver")) {
            return new PostgresConnectionDecorator(delegate);
        }
        if (delegate.getMetaData().getDriverName().equals("Oracle JDBC driver")) {
            return new OracleConnectionDecorator(delegate);
        }
        return new ConnectionDecorator(delegate);
    }

    public int getOpenStatementCount() {
        return this.openStatementCount;
    }

    protected void incrementOpenStatements() {
        ++this.openStatementCount;
        logger.debug((Object)("New Statement opened: Count is " + this.openStatementCount));
    }

    protected void decrementOpenStatements() {
        --this.openStatementCount;
        logger.debug((Object)("Existing Statement closed: Count is " + this.openStatementCount));
    }

    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public Statement createStatement() throws SQLException {
        StatementDecorator stmt = new StatementDecorator(this, this.connection.createStatement());
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        StatementDecorator stmt = new StatementDecorator(this, this.connection.createStatement(resultSetType, resultSetConcurrency));
        return stmt;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        StatementDecorator stmt = new StatementDecorator(this, this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        return stmt;
    }

    public boolean equals(Object obj) {
        return this.connection.equals(obj);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    public String toString() {
        return this.connection.toString();
    }
}

