/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class ArchitectSwingWorker
implements Runnable {
    private static final Logger logger = Logger.getLogger(ArchitectSwingWorker.class);
    private Exception doStuffException;
    private ArchitectSwingWorker nextProcess;
    private boolean cancelled;
    private String cleanupExceptionMessage = "A problem occurred.";

    public final void run() {
        try {
            this.doStuff();
        }
        catch (Exception e) {
            this.doStuffException = e;
            logger.debug((Object)e.getStackTrace());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ArchitectSwingWorker.this.cleanup();
                    if (ArchitectSwingWorker.this.nextProcess != null) {
                        ArchitectSwingWorker.this.nextProcess.setCancelled(ArchitectSwingWorker.this.cancelled);
                        new Thread(ArchitectSwingWorker.this.nextProcess).start();
                    }
                }
                catch (Exception e) {
                    ASUtils.showExceptionDialog(ArchitectSwingWorker.this.cleanupExceptionMessage, e);
                }
            }
        });
    }

    public abstract void cleanup() throws Exception;

    public abstract void doStuff() throws Exception;

    public Exception getDoStuffException() {
        return this.doStuffException;
    }

    public String getCleanupExceptionMessage() {
        return this.cleanupExceptionMessage;
    }

    public void setCleanupExceptionMessage(String cleanupExceptionMessage) {
        this.cleanupExceptionMessage = cleanupExceptionMessage;
    }

    public synchronized boolean isCanceled() {
        return this.cancelled;
    }

    public synchronized void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public ArchitectSwingWorker getNextProcess() {
        return this.nextProcess;
    }

    public void setNextProcess(ArchitectSwingWorker nextProcess) {
        logger.debug((Object)("Moving to object:" + nextProcess));
        this.nextProcess = nextProcess;
    }
}

