/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.profile.ProfileChangeEvent;
import ca.sqlpower.architect.profile.ProfileChangeListener;
import ca.sqlpower.architect.profile.ProfileColumn;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileManager;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ProfilePanel;
import ca.sqlpower.architect.swingui.action.SaveProfileAction;
import ca.sqlpower.architect.swingui.table.ProfileJTable;
import ca.sqlpower.architect.swingui.table.ProfileTableModel;
import ca.sqlpower.architect.swingui.table.TableModelColumnAutofit;
import ca.sqlpower.architect.swingui.table.TableModelSearchDecorator;
import ca.sqlpower.architect.swingui.table.TableModelSortDecorator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import org.apache.log4j.Logger;

public class ProfileResultsViewer {
    private static final Logger logger = Logger.getLogger(ProfileResultsViewer.class);
    private final TableProfileManager profileManager;
    private final Collection<TableProfileResult> results;
    private final JDialog dialog = new JDialog((Frame)ArchitectFrame.getMainInstance(), "Table Profiles");
    private final ProfileTableModel tm;
    private final ProfileChangeListener profileChangeListener = new ProfileChangeListener(){

        public void profilesAdded(ProfileChangeEvent e) {
            List<ProfileResult> profileResult = e.getProfileResult();
            logger.debug((Object)("ProfileResultsViewer.inner.profileAdded()" + profileResult));
        }

        public void profileListChanged(ProfileChangeEvent event) {
            this.disposeIfEmpty();
        }

        public void profilesRemoved(ProfileChangeEvent e) {
            this.disposeIfEmpty();
        }

        private void disposeIfEmpty() {
            for (TableProfileResult tpr : ProfileResultsViewer.this.results) {
                if (!ProfileResultsViewer.this.profileManager.getTableResults().contains(tpr)) continue;
                return;
            }
            ProfileResultsViewer.this.dialog.dispose();
        }
    };

    public ProfileResultsViewer(TableProfileManager profileManager) {
        this.profileManager = profileManager;
        this.results = new ArrayList<TableProfileResult>();
        JTabbedPane tabPane = new JTabbedPane();
        this.tm = new ProfileTableModel(profileManager);
        profileManager.addProfileChangeListener(this.profileChangeListener);
        TableModelSearchDecorator searchDecorator = new TableModelSearchDecorator(this.tm);
        TableModelSortDecorator tableModelSortDecorator = new TableModelSortDecorator(searchDecorator);
        ProfileJTable viewTable = new ProfileJTable(tableModelSortDecorator);
        searchDecorator.setTableTextConverter(viewTable);
        TableModelColumnAutofit columnAutoFit = new TableModelColumnAutofit(tableModelSortDecorator, viewTable);
        JTableHeader tableHeader = viewTable.getTableHeader();
        tableModelSortDecorator.setTableHeader(tableHeader);
        columnAutoFit.setTableHeader(tableHeader);
        viewTable.setAutoResizeMode(4);
        ProfilePanelMouseListener profilePanelMouseListener = new ProfilePanelMouseListener();
        profilePanelMouseListener.setTabPane(tabPane);
        viewTable.addMouseListener(profilePanelMouseListener);
        JScrollPane editorScrollPane = new JScrollPane(viewTable);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(800, 600));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        JPanel tableViewPane = new JPanel(new BorderLayout());
        tableViewPane.add((Component)editorScrollPane, "Center");
        JLabel searchLabel = new JLabel("Search:");
        JTextField searchField = new JTextField(searchDecorator.getDoc(), "", 25);
        searchField.setEditable(true);
        JPanel searchPanel = new JPanel(new FlowLayout(2));
        searchPanel.add(searchLabel);
        searchPanel.add(searchField);
        tableViewPane.add((Component)searchPanel, "North");
        tabPane.addTab("Table View", tableViewPane);
        ProfilePanel p = new ProfilePanel(this.tm);
        p.setViewTable(viewTable);
        p.setTabPane(tabPane);
        p.setTableModel(this.tm);
        tabPane.addTab("Graph View", p);
        profilePanelMouseListener.setProfilePanel(p);
        p.setChartType(ProfilePanel.ChartTypes.PIE);
        if (viewTable.getRowCount() > 0) {
            SQLColumn col = (SQLColumn)viewTable.getValueAt(0, viewTable.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()));
            p.getTableSelector().setSelectedItem(col.getParentTable());
            p.getColumnSelector().setSelectedValue(col, true);
        }
        this.dialog.add((Component)tabPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        JButton save = new JButton(new SaveProfileAction(this.dialog, viewTable, profileManager));
        bottomPanel.add(save);
        JButton closeButton = new JButton("Close");
        bottomPanel.add(closeButton);
        this.dialog.add((Component)bottomPanel, "South");
        this.dialog.setDefaultCloseOperation(2);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfileResultsViewer.this.dialog.dispose();
            }
        });
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        ASUtils.makeJDialogCancellable(this.dialog, null);
    }

    public void addTableProfileResult(TableProfileResult result) {
        this.results.add(result);
        this.tm.refresh();
    }

    public void addTableProfileResultToScan(TableProfileResult result) {
        this.tm.addTableResultToScan(result);
    }

    public void removeTableProfileResultToScan(TableProfileResult result) {
        this.tm.removeTableResultToScan(result);
    }

    public void clearScanList() {
        this.tm.clearScanList();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    private class ProfilePanelMouseListener
    extends MouseAdapter {
        private ProfilePanel profilePanel;
        private JTabbedPane tabPane;

        private ProfilePanelMouseListener() {
        }

        public ProfilePanel getProfilePanel() {
            return this.profilePanel;
        }

        public void setProfilePanel(ProfilePanel profilePanel) {
            this.profilePanel = profilePanel;
        }

        public void mouseClicked(MouseEvent evt) {
            Object obj = evt.getSource();
            if (evt.getClickCount() == 2 && obj instanceof JTable) {
                JTable t = (JTable)obj;
                SQLColumn col = (SQLColumn)t.getValueAt(t.getSelectedRow(), t.convertColumnIndexToView(ProfileColumn.valueOf("COLUMN").ordinal()));
                this.profilePanel.getTableSelector().setSelectedItem(col.getParentTable());
                this.profilePanel.getColumnSelector().setSelectedValue(col, true);
                this.tabPane.setSelectedIndex(1);
            }
        }

        public JTabbedPane getTabPane() {
            return this.tabPane;
        }

        public void setTabPane(JTabbedPane tabPane) {
            this.tabPane = tabPane;
        }
    }
}

