/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLColumnComboBoxModel
implements ComboBoxModel {
    private SQLTable table;
    private List<SQLColumn> usedColumns;
    private SQLColumn selected;

    public SQLColumnComboBoxModel(SQLTable table, List<SQLColumn> usedColumns) throws ArchitectException {
        this.SQLColumnComboBoxModelImpl(table, usedColumns);
    }

    public SQLColumnComboBoxModel(SQLTable table) throws ArchitectException {
        this.SQLColumnComboBoxModelImpl(table, null);
    }

    private void SQLColumnComboBoxModelImpl(SQLTable table, List<SQLColumn> usedColumns) throws ArchitectException {
        if (table == null) {
            throw new NullPointerException();
        }
        this.usedColumns = new ArrayList<SQLColumn>(usedColumns);
        this.table = table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    @Override
    public Object getElementAt(int index) {
        List<SQLColumn> curElements;
        try {
            curElements = this.getAllUsableElement();
        }
        catch (ArchitectException e) {
            throw new ArchitectRuntimeException(e);
        }
        return curElements.get(index);
    }

    @Override
    public int getSize() {
        try {
            List<SQLColumn> curElements = this.getAllUsableElement();
            return curElements.size();
        }
        catch (ArchitectException e) {
            throw new ArchitectRuntimeException(e);
        }
    }

    private List<SQLColumn> getAllUsableElement() throws ArchitectException {
        if (this.table == null) {
            System.err.println("table is null");
        }
        ArrayList<SQLColumn> curElements = new ArrayList<SQLColumn>(this.table.getColumns());
        curElements.removeAll(this.usedColumns);
        curElements.add(0, this.selected);
        if (this.selected != null) {
            curElements.add(null);
        }
        return curElements;
    }

    @Override
    public Object getSelectedItem() {
        return this.selected;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        while (this.usedColumns.remove(this.selected)) {
        }
        this.selected = (SQLColumn)anItem;
        this.usedColumns.add(this.selected);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }

    public SQLTable getTable() {
        return this.table;
    }
}

