/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.part.FileEditorInput;
import org.epic.perleditor.PerlEditorPlugin;

public class FileUtilities {
    public static FileEditorInput getFileEditorInput(IPath fPath) {
        IWorkspaceRoot root = PerlEditorPlugin.getWorkspace().getRoot();
        try {
            IFile[] files = root.findFilesForLocation(fPath);
            if (files.length > 0) {
                return new FileEditorInput(files[0]);
            }
            FileUtilities.createFolderLink(fPath, FileUtilities.getEpicLinksProject(root));
            files = root.findFilesForLocation(fPath);
            if (files.length > 0) {
                return new FileEditorInput(files[0]);
            }
            throw new CoreException((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, String.valueOf(fPath.toOSString()) + " could not be found through epic-links", null));
        }
        catch (CoreException e) {
            IPath folderPath = fPath.removeLastSegments(1);
            IStatus[] status = root.getLocation().isPrefixOf(folderPath) || folderPath.isPrefixOf(root.getLocation()) ? new IStatus[]{e.getStatus(), new Status(4, PerlEditorPlugin.getPluginId(), 0, "EPIC cannot access files located in folders on the path to the workspace folder, nor within the workspace folder itself.", null)} : new IStatus[]{e.getStatus()};
            PerlEditorPlugin.getDefault().getLog().log((IStatus)new MultiStatus(PerlEditorPlugin.getPluginId(), 0, status, "An unexpected exception occurred while creating a link to " + fPath.toString(), (Throwable)e));
            return null;
        }
    }

    private static void createFolderLink(IPath fPath, IProject prj) throws CoreException {
        String name = Long.toString(System.currentTimeMillis());
        IFolder link = prj.getFolder(name);
        while (link.exists()) {
            name = String.valueOf(name) + "_";
            link = prj.getFolder(name);
        }
        link.createLink(fPath.removeLastSegments(1), 0, null);
    }

    private static IProject getEpicLinksProject(IWorkspaceRoot root) throws CoreException {
        IProject prj = root.getProject("epic_links");
        if (!prj.exists()) {
            prj.create(null);
            prj.open(null);
            IProjectDescription description = prj.getDescription();
            String[] natures = new String[]{"org.epic.perleditor.perlinkexternalfilesnature"};
            description.setNatureIds(natures);
            prj.setDescription(description, null);
        } else {
            prj.open(null);
        }
        return prj;
    }
}

