/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.epic.perleditor.editors.AddEditorMarker;

public class MarkerUtil {
    private IResource fResource;
    private static final String EPIC_MARKER_USED_FLAG = "epic.markerUsedFlag";

    public MarkerUtil(IResource resource) {
        this.fResource = resource;
    }

    public void clearAllUsedFlags(String markerType) {
        this.clearAllUsedFlags(markerType, null);
    }

    public void clearAllUsedFlags(String markerType, String additionalAttribute) {
        try {
            IMarker[] markers = this.fResource.findMarkers(markerType, true, 1);
            int i = 0;
            while (i < markers.length) {
                if (additionalAttribute == null || markers[i].getAttribute(additionalAttribute) != null) {
                    markers[i].setAttribute(EPIC_MARKER_USED_FLAG, false);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void removeUnusedMarkers(String markerType) {
        this.removeUnusedMarkers(markerType, null);
    }

    public void removeObsoleteProblemMarkers() {
        try {
            IMarker[] markers = this.fResource.findMarkers("org.eclipse.core.resources.problemmarker", true, 1);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getCreationTime() < 1161441375673L) {
                    markers[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void removeUnusedMarkers(String markerType, String additionalAttribute) {
        try {
            IMarker[] markers = this.fResource.findMarkers(markerType, true, 1);
            int i = 0;
            while (i < markers.length) {
                if (!(additionalAttribute != null && markers[i].getAttribute(additionalAttribute) == null || markers[i].getAttribute(EPIC_MARKER_USED_FLAG, false))) {
                    markers[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void addMarker(Map attributes, String markerType) {
        attributes.put(EPIC_MARKER_USED_FLAG, Boolean.TRUE);
        AddEditorMarker ed = new AddEditorMarker();
        ed.addMarker(this.fResource, attributes, markerType);
    }

    public boolean isMarkerPresent(String makerType, int line, String text, boolean setUsedFlag) {
        return this.isMarkerPresent(makerType, line, text, null, setUsedFlag);
    }

    public boolean isMarkerPresent(String makerType, int line, String text, String additionalAttribute, boolean setUsedFlag) {
        boolean found = false;
        List markers = MarkerUtil.getMarkersForLine(this.fResource, line);
        int i = 0;
        while (i < markers.size()) {
            Marker marker = (Marker)markers.get(i);
            String markerText = marker.getAttribute("message", null);
            try {
                if (marker.getType().equals(makerType) && (additionalAttribute == null || marker.getAttribute(additionalAttribute) != null) && markerText != null && markerText.equals(text)) {
                    found = true;
                    if (!setUsedFlag) break;
                    try {
                        marker.setAttribute(EPIC_MARKER_USED_FLAG, true);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return found;
    }

    public static List getMarkersForLine(IResource resource, int aLine) {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        try {
            IMarker[] allMarkers = resource.findMarkers(null, true, 1);
            int i = 0;
            while (i < allMarkers.length) {
                IMarker marker = allMarkers[i];
                Integer lineNr = (Integer)marker.getAttribute("lineNumber");
                if (lineNr != null && lineNr == aLine) {
                    markers.add(marker);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return markers;
    }
}

