/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.textmanipulation;

import org.eclipse.core.runtime.CoreException;
import org.epic.perleditor.templates.textmanipulation.NopTextEdit;
import org.epic.perleditor.templates.textmanipulation.TextBuffer;
import org.epic.perleditor.templates.textmanipulation.TextBufferEditor;
import org.epic.perleditor.templates.textmanipulation.TextEdit;
import org.epic.perleditor.templates.textmanipulation.TextRange;

public final class MoveTextEdit
extends TextEdit {
    private TextRange fTarget;
    private TextRange fSource;
    private int fPerformCounter;

    public MoveTextEdit(int offset, int length, int destination) {
        this.fSource = new TextRange(offset, length);
        this.fTarget = new TextRange(destination);
    }

    private MoveTextEdit(TextRange source, TextRange target) {
        this.fSource = source;
        this.fTarget = target;
    }

    public TextRange getSourceRange() {
        return this.fSource;
    }

    public TextRange getTargetRange() {
        return this.fTarget;
    }

    public TextRange getTextRange() {
        return this.fSource;
    }

    public void connect(TextBufferEditor editor) throws CoreException {
        editor.add(new TargetMark(this.fTarget, this));
    }

    public TextEdit perform(TextBuffer buffer) throws CoreException {
        this.internalPerform(buffer);
        return new MoveTextEdit(this.fTarget, this.fSource);
    }

    public TextEdit copy() {
        TextRange source = this.getSourceRange();
        TextRange target = this.getTargetRange();
        return new MoveTextEdit(source.fOffset, source.fLength, target.fOffset);
    }

    private void internalPerform(TextBuffer buffer) throws CoreException {
        if (++this.fPerformCounter == 2) {
            TextRange source = this.getSourceRange();
            TextRange target = this.getTargetRange();
            String current = buffer.getContent(source.fOffset, source.fLength);
            buffer.replace(source, "");
            buffer.replace(target, current);
        }
    }

    boolean isUpMove() {
        return this.fSource.fOffset < this.fTarget.fOffset;
    }

    boolean isDownMove() {
        return this.fSource.fOffset > this.fTarget.fOffset;
    }

    TextRange getChildRange() {
        int offset = this.fSource.fOffset;
        int length = this.fSource.fLength;
        int destination = this.fTarget.fOffset;
        if (destination <= offset) {
            return new TextRange(destination, offset + length - destination);
        }
        return new TextRange(offset, destination - offset);
    }

    static class TargetMark
    extends NopTextEdit {
        private MoveTextEdit fMoveTextEdit;

        public TargetMark(TextRange range, MoveTextEdit edit) {
            super(range);
            this.fMoveTextEdit = edit;
        }

        MoveTextEdit getMoveTextEdit() {
            return this.fMoveTextEdit;
        }

        public TextEdit perform(TextBuffer buffer) throws CoreException {
            this.fMoveTextEdit.internalPerform(buffer);
            return super.perform(buffer);
        }

        public TextEdit copy() {
            return super.copy();
        }
    }
}

