/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.console;

public class ConsoleDocument {
    private int[] lineTypes;
    private String[] lines;
    private int writeIndex = 0;
    private int readIndex = 0;
    private static final int BUFFER_SIZE = 200;

    public void clear() {
        this.lineTypes = null;
        this.lines = null;
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public void appendConsoleLine(int type, String line) {
        if (this.lines == null) {
            this.lines = new String[200];
            this.lineTypes = new int[200];
        }
        this.lines[this.writeIndex] = line;
        this.lineTypes[this.writeIndex] = type;
        if (++this.writeIndex >= 200) {
            this.writeIndex = 0;
        }
        if (this.writeIndex == this.readIndex && ++this.readIndex >= 200) {
            this.readIndex = 0;
        }
    }

    public ConsoleLine[] getLines() {
        if (this.isEmpty()) {
            return new ConsoleLine[0];
        }
        ConsoleLine[] docLines = new ConsoleLine[this.readIndex > this.writeIndex ? 200 : this.writeIndex];
        int index = this.readIndex;
        int i = 0;
        while (i < docLines.length) {
            docLines[i] = new ConsoleLine(this.lines[index], this.lineTypes[index]);
            if (++index >= 200) {
                index = 0;
            }
            ++i;
        }
        return docLines;
    }

    public boolean isEmpty() {
        return this.writeIndex == this.readIndex;
    }

    protected static class ConsoleLine {
        public String line;
        public int type;

        ConsoleLine(String line, int type) {
            this.line = line;
            this.type = type;
        }
    }
}

