/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.derby.catalog;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DataModelElementFactory;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.derby.catalog.DerbyCatalogDatabase;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.GenerateType;
import org.eclipse.wst.rdb.internal.models.sql.schema.IdentitySpecifier;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.impl.ColumnImpl;

public class DerbyCatalogColumn
extends ColumnImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3257570602843189304L;
    private boolean identityLoaded = false;

    public void refresh() {
        this.identityLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((DerbyCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getTable().getSchema().getDatabase();
    }

    public IdentitySpecifier getIdentitySpecifier() {
        if (!this.identityLoaded) {
            this.loadIdentity();
        }
        return this.identitySpecifier;
    }

    public String getDefaultValue() {
        if (!this.identityLoaded) {
            this.loadIdentity();
        }
        return this.defaultValue;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getIdentitySpecifier();
        } else if (id == 13) {
            this.getDefaultValue();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadIdentity() {
        if (this.identityLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        DerbyCatalogColumn.loadIdentity(connection, (Column)this);
        this.identityLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadIdentity(Connection connection, Column column) {
        try {
            Database database = column.getTable().getSchema().getDatabase();
            DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
            DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
            Statement s = connection.createStatement();
            String query = "SELECT COLUMNDEFAULT,AUTOINCREMENTVALUE,AUTOINCREMENTSTART FROM SYS.SYSCOLUMNS A, SYS.SYSTABLES B, SYS.SYSSCHEMAS C WHERE A.REFERENCEID=B.TABLEID AND B.TABLENAME='" + column.getTable().getName() + "'" + " AND B.SCHEMAID=C.SCHEMAID" + " AND C.SCHEMANAME='" + column.getTable().getSchema().getName() + "'" + " AND A.COLUMNNAME='" + column.getName() + "'";
            ResultSet r = s.executeQuery(query);
            IdentitySpecifier identitySpecifier = (IdentitySpecifier)factory.create(SQLSchemaPackage.eINSTANCE.getIdentitySpecifier());
            while (r.next()) {
                long increment;
                Serializable defaultValue = (Serializable)r.getObject("COLUMNDEFAULT");
                if (defaultValue != null) {
                    if (defaultValue.toString().equals("GENERATED_BY_DEFAULT")) {
                        identitySpecifier.setGenerationType(GenerateType.DEFAULT_GENERATED_LITERAL);
                    } else {
                        column.setDefaultValue(defaultValue.toString());
                    }
                }
                if ((increment = r.getLong("AUTOINCREMENTVALUE")) == 0L) continue;
                if (defaultValue == null) {
                    identitySpecifier.setGenerationType(GenerateType.ALWAYS_GENERATED_LITERAL);
                }
                identitySpecifier.setStartValue(BigInteger.valueOf(r.getLong("AUTOINCREMENTSTART")));
                identitySpecifier.setIncrement(BigInteger.valueOf(increment));
                column.setIdentitySpecifier(identitySpecifier);
            }
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

