/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.internal.databinding.internal.ValidationErrorList;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingEvent;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.IBindingListener;
import org.eclipse.jface.internal.databinding.provisional.conversion.IConverter;
import org.eclipse.jface.internal.databinding.provisional.factories.BindSupportFactory;
import org.eclipse.jface.internal.databinding.provisional.factories.DefaultBindSupportFactory;
import org.eclipse.jface.internal.databinding.provisional.factories.DefaultBindingFactory;
import org.eclipse.jface.internal.databinding.provisional.factories.IBindingFactory;
import org.eclipse.jface.internal.databinding.provisional.factories.IObservableFactory;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.list.IObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.WritableList;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ComputedValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.IDomainValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;
import org.eclipse.jface.util.Assert;

public final class DataBindingContext {
    public static final int POLICY_AUTOMATIC = 1;
    public static final int POLICY_EXPLICIT = 2;
    public static final int TIME_EARLY = 0;
    public static final int TIME_LATE = 1;
    private List bindingEventListeners = new ArrayList();
    private WritableList bindings = new WritableList();
    private List bindSupportFactories = new ArrayList();
    private List bindingFactories = new ArrayList();
    private List createdObservables = new ArrayList();
    private List factories = new ArrayList();
    private DataBindingContext parent;
    private ComputedValue partialValidationError = new ComputedValue(){

        protected Object calculate() {
            int size = DataBindingContext.this.partialValidationErrors.size();
            return size == 0 ? null : DataBindingContext.this.partialValidationErrors.get(size - 1);
        }
    };
    private ObservableList partialValidationErrors = new ValidationErrorList(this.bindings, true);
    private ComputedValue validationError = new ComputedValue(){

        protected Object calculate() {
            int size = DataBindingContext.this.validationErrors.size();
            return size == 0 ? null : DataBindingContext.this.validationErrors.get(size - 1);
        }
    };
    private ObservableList validationErrors = new ValidationErrorList(this.bindings, false);

    public static DataBindingContext createContext(DataBindingContext parent) {
        DataBindingContext result = new DataBindingContext(parent);
        return result;
    }

    public static DataBindingContext createContext(IObservableFactory[] observableFactories) {
        return DataBindingContext.createContext(observableFactories, new BindSupportFactory[]{new DefaultBindSupportFactory()}, new IBindingFactory[]{new DefaultBindingFactory()});
    }

    public static DataBindingContext createContext(IObservableFactory[] observableFactories, BindSupportFactory[] bindSupportFactories, IBindingFactory[] bindingFactories) {
        int i;
        DataBindingContext result = new DataBindingContext();
        if (observableFactories != null) {
            i = 0;
            while (i < observableFactories.length) {
                result.addObservableFactory(observableFactories[i]);
                ++i;
            }
        }
        if (bindSupportFactories != null) {
            i = 0;
            while (i < bindSupportFactories.length) {
                result.addBindSupportFactory(bindSupportFactories[i]);
                ++i;
            }
        }
        if (bindingFactories != null) {
            i = 0;
            while (i < bindingFactories.length) {
                result.addBindingFactory(bindingFactories[i]);
                ++i;
            }
        }
        return result;
    }

    public DataBindingContext() {
    }

    public DataBindingContext(DataBindingContext parent) {
        this.parent = parent;
    }

    public void addBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.add(listener);
    }

    public void addBindSupportFactory(BindSupportFactory factory) {
        this.bindSupportFactories.add(factory);
    }

    public void addObservableFactory(IObservableFactory observableFactory) {
        this.factories.add(observableFactory);
    }

    public void addBindingFactory(IBindingFactory factory) {
        this.bindingFactories.add(factory);
    }

    public Binding bind(IObservable targetObservable, IObservable modelObservable, BindSpec bindSpec) {
        Binding result = this.doCreateBinding(targetObservable, modelObservable, bindSpec, this);
        if (result != null) {
            return result;
        }
        throw new BindingException("No binding found for target: " + targetObservable.getClass().getName() + ", model: " + modelObservable.getClass().getName());
    }

    private Binding doCreateBinding(IObservable targetObservable, IObservable modelObservable, BindSpec bindSpec, DataBindingContext originatingContext) {
        int i = this.bindingFactories.size() - 1;
        while (i >= 0) {
            IBindingFactory factory = (IBindingFactory)this.bindingFactories.get(i);
            Binding binding = factory.createBinding(originatingContext, targetObservable, modelObservable, bindSpec);
            if (binding != null) {
                this.bindings.add(binding);
                return binding;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.doCreateBinding(targetObservable, modelObservable, bindSpec, originatingContext);
        }
        return null;
    }

    public Binding bind(IObservable targetObservable, Object modelDescription, BindSpec bindSpec) {
        return this.bind(targetObservable, this.createObservable(modelDescription), bindSpec);
    }

    public Binding bind(Object targetDescription, IObservable modelObservable, BindSpec bindSpec) {
        return this.bind(this.createObservable(targetDescription), modelObservable, bindSpec);
    }

    public Binding bind(Object targetDescription, Object modelDescription, BindSpec bindSpec) {
        return this.bind(this.createObservable(targetDescription), modelDescription, bindSpec);
    }

    public IConverter createConverter(Object fromType, Object toType) {
        int i = this.bindSupportFactories.size() - 1;
        while (i >= 0) {
            BindSupportFactory bindSupportFactory = (BindSupportFactory)this.bindSupportFactories.get(i);
            IConverter converter = bindSupportFactory.createConverter(fromType, toType);
            if (converter != null) {
                return converter;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.createConverter(fromType, toType);
        }
        return null;
    }

    public IDomainValidator createDomainValidator(Object modelType) {
        int i = this.bindSupportFactories.size() - 1;
        while (i >= 0) {
            BindSupportFactory bindSupportFactory = (BindSupportFactory)this.bindSupportFactories.get(i);
            IDomainValidator validator = bindSupportFactory.createDomainValidator(modelType);
            if (validator != null) {
                return validator;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.createDomainValidator(modelType);
        }
        return null;
    }

    public IObservable createObservable(Object description) {
        IObservable updatable = this.doCreateObservable(description, this);
        if (updatable != null) {
            this.createdObservables.add(updatable);
        }
        return updatable;
    }

    public IValidator createValidator(Object fromType, Object toType) {
        int i = this.bindSupportFactories.size() - 1;
        while (i >= 0) {
            BindSupportFactory bindSupportFactory = (BindSupportFactory)this.bindSupportFactories.get(i);
            IValidator validator = bindSupportFactory.createValidator(fromType, toType);
            if (validator != null) {
                return validator;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.createValidator(fromType, toType);
        }
        return null;
    }

    public void dispose() {
        for (IObservable updatable : this.createdObservables) {
            updatable.dispose();
        }
    }

    private IObservable doCreateObservable(Object description, DataBindingContext thisDatabindingContext) {
        int i = this.factories.size() - 1;
        while (i >= 0) {
            IObservableFactory factory = (IObservableFactory)this.factories.get(i);
            IObservable result = factory.createObservable(description);
            if (result != null) {
                return result;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.doCreateObservable(description, thisDatabindingContext);
        }
        throw new BindingException("could not find updatable for " + description);
    }

    public void fillBindSpecDefaults(DataBindingContext dataBindingContext, BindSpec bindSpec, Object targetType, Object modelType) {
        if (bindSpec.getTypeConversionValidator() == null) {
            bindSpec.setValidator(dataBindingContext.createValidator(targetType, modelType));
        }
        if (bindSpec.getDomainValidator() == null) {
            bindSpec.setDomainValidator(dataBindingContext.createDomainValidator(modelType));
        }
        if (bindSpec.getModelToTargetConverter() == null) {
            bindSpec.setModelToTargetConverter(dataBindingContext.createConverter(modelType, targetType));
        }
        if (bindSpec.getTargetToModelConverter() == null) {
            bindSpec.setTargetToModelConverter(dataBindingContext.createConverter(targetType, modelType));
        }
    }

    ValidationError fireBindingEvent(BindingEvent event) {
        ValidationError result = null;
        for (IBindingListener listener : this.bindingEventListeners) {
            result = listener.bindingEvent(event);
            if (result != null) break;
        }
        return result;
    }

    public IObservableList getBindings() {
        return this.bindings;
    }

    public IObservableValue getPartialValidationError() {
        return this.partialValidationError;
    }

    public IObservableValue getValidationError() {
        return this.validationError;
    }

    public IObservableList getValidationErrors() {
        return this.validationErrors;
    }

    public boolean isAssignableFromTo(Object fromType, Object toType) {
        int i = this.bindSupportFactories.size() - 1;
        while (i >= 0) {
            BindSupportFactory bindSupportFactory = (BindSupportFactory)this.bindSupportFactories.get(i);
            Boolean result = bindSupportFactory.isAssignableFromTo(fromType, toType);
            if (result != null) {
                return result;
            }
            --i;
        }
        if (this.parent != null) {
            return this.parent.isAssignableFromTo(fromType, toType);
        }
        return true;
    }

    public void registerForDispose(IObservable observable) {
        this.createdObservables.add(observable);
    }

    public void removeBindingEventListener(IBindingListener listener) {
        this.bindingEventListeners.remove(listener);
    }

    public void updateModels() {
        Assert.isTrue((boolean)false, (String)"updateModels is not yet implemented");
    }

    public void updateTargets() {
        Assert.isTrue((boolean)false, (String)"updateTargets is not yet implemented");
    }
}

