/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.viewers;

import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;

public class SelectionObservableValue
extends AbstractObservableValue {
    private StructuredViewer viewer;
    private Object currentSelection = null;
    private ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object oldSelection = SelectionObservableValue.this.currentSelection;
            Object newSelection = selection.getFirstElement();
            if (newSelection != oldSelection) {
                SelectionObservableValue.this.currentSelection = newSelection;
                SelectionObservableValue.this.fireValueChange(Diffs.createValueDiff(oldSelection, newSelection));
            }
        }
    };

    public SelectionObservableValue(StructuredViewer viewer) {
        this.viewer = viewer;
        viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.currentSelection = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
    }

    protected Object doGetValue() {
        return this.currentSelection;
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener(this.selectionChangedListener);
        this.viewer = null;
        this.currentSelection = null;
        this.selectionChangedListener = null;
        super.dispose();
    }

    public Object getValueType() {
        return Object.class;
    }
}

