/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import org.eclipse.jface.dialogs.ControlAnimator;
import org.eclipse.jface.dialogs.ImageAndMessageArea;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TitleAreaDialog
extends TrayDialog {
    public static final String DLG_IMG_TITLE_ERROR = "dialog_message_error_image";
    public static final String DLG_IMG_TITLE_BANNER = "dialog_title_banner_image";
    public static final String INFO_MESSAGE = "INFO_MESSAGE";
    public static final String WARNING_MESSAGE = "WARNING_MESSAGE";
    private static final int H_GAP_IMAGE = 5;
    private static final int MIN_DIALOG_WIDTH = 350;
    private static final int MIN_DIALOG_HEIGHT = 150;
    private Label titleLabel;
    private Label titleImageLabel;
    private Image titleImage;
    private Label leftFillerLabel;
    private RGB titleAreaRGB;
    Color titleAreaColor;
    private String message = "";
    private String errorMessage;
    private Text messageLabel;
    private Composite workArea;
    private Composite titleArea;
    private Label messageImageLabel;
    private Image messageImage;
    private boolean showingError = false;
    private boolean showingWarning = false;
    private boolean titleImageLargest = true;
    private int messageLabelHeight;
    private ImageAndMessageArea messageArea;
    private String warningMessage;
    private ControlAnimator animator;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(DLG_IMG_TITLE_BANNER, ImageDescriptor.createFromFile(TitleAreaDialog.class, "images/title_banner.gif"));
    }

    public TitleAreaDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)contents);
        FormLayout layout = new FormLayout();
        contents.setLayout((Layout)layout);
        this.workArea = new Composite(contents, 0);
        GridLayout childLayout = new GridLayout();
        childLayout.marginHeight = 0;
        childLayout.marginWidth = 0;
        childLayout.verticalSpacing = 0;
        this.workArea.setLayout((Layout)childLayout);
        Control top = this.createTitleArea(contents);
        this.resetWorkAreaAttachments(top);
        this.workArea.setFont(JFaceResources.getDialogFont());
        this.initializeDialogUnits((Control)this.workArea);
        this.dialogArea = this.createDialogArea(this.workArea);
        this.buttonBar = this.createButtonBar(this.workArea);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Control createTitleArea(Composite parent) {
        Color foreground;
        Color background;
        this.titleArea = new Composite(parent, 0);
        this.initializeDialogUnits((Control)this.titleArea);
        FormData titleAreaData = new FormData();
        titleAreaData.top = new FormAttachment(0, 0);
        titleAreaData.left = new FormAttachment(0, 0);
        titleAreaData.right = new FormAttachment(100, 0);
        this.titleArea.setLayoutData((Object)titleAreaData);
        FormLayout layout = new FormLayout();
        this.titleArea.setLayout((Layout)layout);
        this.titleArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TitleAreaDialog.this.titleAreaColor != null) {
                    TitleAreaDialog.this.titleAreaColor.dispose();
                }
            }
        });
        Display display = this.titleArea.getDisplay();
        if (this.titleAreaRGB != null) {
            background = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground(display);
            foreground = JFaceColors.getBannerForeground(display);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.titleArea.setBackground(background);
        this.titleImageLabel = new Label(this.titleArea, 0x1000000);
        this.titleImageLabel.setBackground(background);
        if (this.titleImage == null || this.titleImage.isDisposed()) {
            this.titleImageLabel.setImage(JFaceResources.getImage(DLG_IMG_TITLE_BANNER));
        } else {
            this.titleImageLabel.setImage(this.titleImage);
        }
        FormData imageData = new FormData();
        imageData.top = new FormAttachment(0, 0);
        imageData.right = new FormAttachment(100, 0);
        this.titleImageLabel.setLayoutData((Object)imageData);
        this.titleLabel = new Label(this.titleArea, 16384);
        JFaceColors.setColors((Control)this.titleLabel, foreground, background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.top = new FormAttachment(0, verticalSpacing);
        titleData.right = new FormAttachment((Control)this.titleImageLabel);
        titleData.left = new FormAttachment(0, horizontalSpacing);
        this.titleLabel.setLayoutData((Object)titleData);
        this.messageImageLabel = new Label(this.titleArea, 0x1000000);
        this.messageImageLabel.setBackground(background);
        this.messageLabel = new Text(this.titleArea, 72);
        JFaceColors.setColors((Control)this.messageLabel, foreground, background);
        this.messageLabel.setText(" \n ");
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label(this.titleArea, 0x1000000);
        this.leftFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        this.determineTitleImageLargest();
        return this.titleArea;
    }

    private void determineTitleImageLargest() {
        int titleY = this.titleImageLabel.computeSize((int)-1, (int)-1).y;
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int labelY = this.titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += verticalSpacing;
        labelY += this.messageLabelHeight;
        this.titleImageLargest = titleY > (labelY += verticalSpacing);
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
        messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, horizontalSpacing);
        messageLabelData.height = this.messageLabelHeight;
        if (this.titleImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)messageLabelData);
        FormData imageLabelData = new FormData();
        imageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        imageLabelData.left = new FormAttachment((Control)this.leftFillerLabel);
        imageLabelData.right = new FormAttachment((Control)this.messageLabel);
        this.messageImageLabel.setLayoutData((Object)imageLabelData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.titleLabel, 0, 128);
        data.left = new FormAttachment(0, 5);
        data.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.leftFillerLabel.setLayoutData((Object)data);
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(350), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(150), shellSize.y));
    }

    protected Composite getTitleArea() {
        return this.getShell();
    }

    protected Label getTitleImageLabel() {
        return this.titleImageLabel;
    }

    public void setErrorMessage(String newErrorMessage) {
        if (this.errorMessage == null ? newErrorMessage == null : this.errorMessage.equals(newErrorMessage)) {
            return;
        }
        this.errorMessage = newErrorMessage;
        if (this.errorMessage == null) {
            if (this.messageArea != null && !this.showingWarning) {
                this.setMessageAreaVisible(false);
            }
            if (this.showingError) {
                this.showingError = false;
            }
            if (this.message == null) {
                this.message = "";
            }
            this.updateMessage(this.message);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            if (this.showingWarning) {
                this.setWarningMessage(this.warningMessage);
            }
        } else {
            if (!this.showingError) {
                this.showingError = true;
            }
            if (this.showingWarning) {
                this.setWarningMessage(null);
            }
            if (this.messageArea == null) {
                this.messageArea = new ImageAndMessageArea(this.titleArea, 64);
                this.messageArea.setBackground(this.messageLabel.getBackground());
                this.animator = Policy.getAnimatorFactory().createAnimator((Control)this.messageArea);
            }
            this.messageArea.setToolTipText(this.errorMessage);
            this.messageArea.setText(this.errorMessage);
            this.messageArea.setImage(JFaceResources.getImage(DLG_IMG_TITLE_ERROR));
            this.setMessageAreaVisible(true);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
    }

    private void setMessageAreaVisible(boolean visible) {
        this.messageArea.moveAbove(null);
        int bottom = this.titleArea.getBounds().y + this.titleArea.getBounds().height;
        Rectangle msgLabelBounds = this.messageLabel.getBounds();
        if (!this.messageArea.isVisible() && this.messageArea.getBounds().y != bottom) {
            this.messageArea.setBounds(this.messageImageLabel == null ? msgLabelBounds.x : this.messageImageLabel.getBounds().x, bottom, this.messageImageLabel == null ? msgLabelBounds.width : msgLabelBounds.width + this.messageImageLabel.getBounds().width, this.messageArea.computeSize((int)-1, (int)-1).y);
        }
        this.animator.setVisible(visible);
        this.setMessageLayoutData();
    }

    private void setMessageLayoutData() {
        if (this.messageArea == null) {
            return;
        }
        FormData messageAreaData = new FormData();
        messageAreaData.right = new FormAttachment((Control)this.titleImageLabel);
        messageAreaData.left = new FormAttachment((Control)this.leftFillerLabel);
        messageAreaData.bottom = new FormAttachment(100, 0);
        this.messageArea.setLayoutData(messageAreaData);
    }

    private void layoutForNewMessage() {
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        if (this.dialogArea != null) {
            this.workArea.getParent().layout(true);
            this.titleArea.layout(true);
        }
    }

    public void setMessage(String newMessage) {
        this.setMessage(newMessage, 0);
    }

    public void setMessage(String newMessage, int newType) {
        Image newImage = null;
        if (newMessage != null) {
            switch (newType) {
                case 0: {
                    break;
                }
                case 1: {
                    newImage = JFaceResources.getImage("dialog_messasge_info_image");
                    break;
                }
                case 2: {
                    newImage = JFaceResources.getImage("dialog_messasge_warning_image");
                    break;
                }
                case 3: {
                    newImage = JFaceResources.getImage(DLG_IMG_TITLE_ERROR);
                }
            }
        }
        if (newType == 2) {
            this.setWarningMessage(newMessage);
        } else {
            this.setWarningMessage(null);
            this.showMessage(newMessage, newImage);
        }
    }

    private void showMessage(String newMessage, Image newImage) {
        if (this.message.equals(newMessage) && this.messageImage == newImage) {
            return;
        }
        this.message = newMessage;
        if (this.message == null) {
            this.message = "";
        }
        String shownMessage = this.message;
        this.messageImage = newImage;
        if (!this.showingError) {
            this.updateMessage(shownMessage);
            this.messageImageLabel.setImage(this.messageImage);
            this.setImageLabelVisible(this.messageImage != null);
            this.layoutForNewMessage();
        }
    }

    private void updateMessage(String newMessage) {
        this.messageLabel.setText(newMessage);
    }

    public void setTitle(String newTitle) {
        if (this.titleLabel == null) {
            return;
        }
        String title = newTitle;
        if (title == null) {
            title = "";
        }
        this.titleLabel.setText(title);
    }

    public void setTitleAreaColor(RGB color) {
        this.titleAreaRGB = color;
    }

    public void setTitleImage(Image newTitleImage) {
        this.titleImage = newTitleImage;
        if (this.titleImageLabel != null && !this.titleImageLabel.isDisposed()) {
            this.titleImageLabel.setImage(newTitleImage);
            this.titleImageLabel.setVisible(newTitleImage != null);
            if (newTitleImage != null) {
                this.resetWorkAreaAttachments((Control)this.titleArea);
            }
        }
    }

    private void setImageLabelVisible(boolean visible) {
        this.messageImageLabel.setVisible(visible);
        this.leftFillerLabel.setVisible(visible);
    }

    private void resetWorkAreaAttachments(Control top) {
        FormData childData = new FormData();
        childData.top = new FormAttachment(top);
        childData.right = new FormAttachment(100, 0);
        childData.left = new FormAttachment(0, 0);
        childData.bottom = new FormAttachment(100, 0);
        this.workArea.setLayoutData((Object)childData);
    }

    private void setWarningMessage(String newMessage) {
        if (this.warningMessage == null ? newMessage == null : this.warningMessage.equals(newMessage)) {
            return;
        }
        this.warningMessage = newMessage;
        if (this.warningMessage == null) {
            if (this.messageArea != null && !this.showingError) {
                this.setMessageAreaVisible(false);
            }
            if (this.showingWarning) {
                this.showingWarning = false;
            }
        } else {
            if (!this.showingWarning) {
                this.showingWarning = true;
            }
            this.warningMessage = newMessage;
            if (this.messageArea == null) {
                this.messageArea = new ImageAndMessageArea(this.titleArea, 64);
                this.messageArea.setBackground(this.messageLabel.getBackground());
                this.animator = Policy.getAnimatorFactory().createAnimator((Control)this.messageArea);
            }
            this.messageArea.setToolTipText(this.warningMessage);
            this.messageArea.setText(this.warningMessage);
            this.messageArea.setImage(JFaceResources.getImage("dialog_messasge_warning_image"));
            this.setMessageAreaVisible(true);
        }
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
    }
}

