/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class FileRevisionEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput {
    private IFileRevision file;
    private IStorage storage;

    public FileRevisionEditorInput(IFileRevision file) {
        this.file = file;
        try {
            this.storage = file.getStorage((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            TeamUIPlugin.log(e);
        }
    }

    public FileRevisionEditorInput(IFileState state) {
        this.storage = state;
        this.file = null;
    }

    public IStorage getStorage() throws CoreException {
        return this.storage;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.file != null) {
            return NLS.bind((String)TeamUIMessages.nameAndRevision, (Object[])new String[]{this.file.getName(), this.file.getContentIdentifier()});
        }
        if (this.storage != null) {
            return String.valueOf(this.storage.getName()) + " " + DateFormat.getInstance().format(new Date(((IFileState)this.storage).getModificationTime()));
        }
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        if (this.file != null) {
            try {
                return this.getStorage().getFullPath().toString();
            }
            catch (CoreException coreException) {}
        }
        if (this.storage != null) {
            return this.storage.getFullPath().toString();
        }
        return "";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        if (adapter == IFileRevision.class) {
            return this.file;
        }
        return super.getAdapter(adapter);
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (this.file != null) {
            return this.file.getName();
        }
        if (this.storage != null) {
            return this.storage.getName();
        }
        return "";
    }

    public Object getParent(Object o) {
        return null;
    }
}

