/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.WorkingSetScope;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IMemento;

public abstract class AbstractSynchronizeScope
implements ISynchronizeScope {
    private static final String CTX_SUBSCRIBER_SCOPE_TYPE = "org.eclipse.team.ui.SCOPE_TYPE";
    private ListenerList listeners = new ListenerList(1);

    protected static void saveScope(ISynchronizeScope scope, IMemento settings) {
        settings.putString(CTX_SUBSCRIBER_SCOPE_TYPE, AbstractSynchronizeScope.getType(scope));
        ((AbstractSynchronizeScope)scope).saveState(settings);
    }

    protected static ISynchronizeScope createScope(IMemento settings) {
        String type = settings.getString(CTX_SUBSCRIBER_SCOPE_TYPE);
        if (type == null) {
            return new WorkspaceScope();
        }
        if (type.equals("ResourceScope")) {
            return new ResourceScope(settings);
        }
        if (type.equals("WorkingSetScope")) {
            return new WorkingSetScope(settings);
        }
        return new WorkspaceScope();
    }

    private static String getType(ISynchronizeScope scope) {
        String name = scope.getClass().getName();
        int lastDot = name.lastIndexOf(".");
        if (lastDot == -1) {
            return name;
        }
        return name.substring(lastDot + 1);
    }

    protected AbstractSynchronizeScope() {
    }

    protected AbstractSynchronizeScope(IMemento memento) {
        this.init(memento);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            this.listeners.remove((Object)this.listeners);
        }
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePropertyChangedEvent(final PropertyChangeEvent event) {
        Object[] allListeners;
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            allListeners = this.listeners.getListeners();
        }
        int i = 0;
        while (i < allListeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)allListeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.propertyChange(event);
                }
            });
            ++i;
        }
    }

    protected void fireRootsChanges() {
        this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "prop_roots", (Object)new IResource[0], (Object)this.getRoots()));
    }

    public void saveState(IMemento memento) {
    }

    protected void init(IMemento memento) {
    }

    public boolean contains(IResource resource) {
        IResource[] roots = this.getRoots();
        IPath resourcePath = resource.getFullPath();
        int i = 0;
        while (i < roots.length) {
            IResource root = roots[i];
            if (root.getFullPath().isPrefixOf(resourcePath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ResourceMapping[] getMappings() {
        ArrayList<Object> result = new ArrayList<Object>();
        IResource[] roots = this.getRoots();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            result.add(resource.getAdapter(ResourceMapping.class));
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }
}

