/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ui.Utils;

public class CVSActionSelectionProperties {
    private static Map selectionProperties = new WeakHashMap();
    private Object[] selection;
    private Map properties = new HashMap();
    private static final String SELECTED_RESOURCES = "selectedResources";
    private static final String NONOVERLAPPING_SELECTED_RESOURCES = "nonoverlappingSelectedResources";
    private static final String CVS_RESOURCE_MAP = "cvsResourceMap";

    public static CVSActionSelectionProperties getProperties(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        CVSActionSelectionProperties props = (CVSActionSelectionProperties)selectionProperties.get(selection);
        if (props == null) {
            props = new CVSActionSelectionProperties(selection);
            selectionProperties.put(selection, props);
        }
        return props;
    }

    public CVSActionSelectionProperties(IStructuredSelection selection) {
        this.selection = selection.toArray();
    }

    public void put(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object get(String key) {
        return this.properties.get(key);
    }

    public IResource[] getAllSelectedResources() {
        IResource[] resources = (IResource[])this.get(SELECTED_RESOURCES);
        if (resources == null) {
            resources = this.getResources(this.selection);
            this.put(SELECTED_RESOURCES, resources);
        }
        return resources;
    }

    private IResource[] getResources(Object[] objects) {
        return Utils.getContributedResources((Object[])objects);
    }

    public IResource[] getNonoverlappingSelectedResources() {
        IResource[] resources = (IResource[])this.get(NONOVERLAPPING_SELECTED_RESOURCES);
        if (resources == null) {
            resources = CVSActionSelectionProperties.getNonOverlapping(this.getAllSelectedResources());
            this.put(NONOVERLAPPING_SELECTED_RESOURCES, resources);
        }
        return resources;
    }

    public ICVSResource getCVSResourceFor(IResource resource) {
        ICVSResource cvsResource;
        HashMap<IResource, ICVSResource> map = (HashMap<IResource, ICVSResource>)this.get(CVS_RESOURCE_MAP);
        if (map == null) {
            map = new HashMap<IResource, ICVSResource>();
            this.put(CVS_RESOURCE_MAP, map);
        }
        if ((cvsResource = (ICVSResource)map.get(resource)) == null) {
            cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
            map.put(resource, cvsResource);
        }
        return cvsResource;
    }

    public static IResource[] getNonOverlapping(IResource[] resources) {
        if (resources == null || resources.length == 0 || resources.length == 1) {
            return resources;
        }
        ArrayList sorted = new ArrayList();
        sorted.addAll(Arrays.asList(resources));
        Collections.sort(sorted, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IResource resource0 = (IResource)arg0;
                IResource resource1 = (IResource)arg1;
                return resource0.getFullPath().segmentCount() - resource1.getFullPath().segmentCount();
            }

            public boolean equals(Object arg0) {
                return false;
            }
        });
        ArrayList<IPath> coveredPaths = new ArrayList<IPath>();
        Iterator iter = sorted.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IPath resourceFullPath = resource.getFullPath();
            boolean covered = false;
            for (IPath path : coveredPaths) {
                if (!path.isPrefixOf(resourceFullPath)) continue;
                covered = true;
            }
            if (covered) {
                iter.remove();
                continue;
            }
            if (resource.getType() != 2) continue;
            coveredPaths.add(resource.getFullPath());
        }
        return sorted.toArray(new IResource[sorted.size()]);
    }
}

