/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.XMLWriter;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.model.URLEntryModel;

public class FeatureWriter
extends XMLWriter
implements IPDEBuildConstants {
    protected Feature feature;
    protected FeatureBuildScriptGenerator generator;
    private Map parameters = new HashMap(10);

    public FeatureWriter(OutputStream out, Feature feature, FeatureBuildScriptGenerator generator) throws IOException {
        super(out);
        this.feature = feature;
        this.generator = generator;
    }

    public void printFeature() throws CoreException {
        this.printFeatureDeclaration();
        this.printInstallHandler();
        this.printDescription();
        this.printCopyright();
        this.printLicense();
        this.printURL();
        this.printIncludes();
        this.printRequires();
        this.printPlugins();
        this.printData();
        this.endTag("feature");
        super.close();
    }

    public void printFeatureDeclaration() {
        this.parameters.clear();
        this.parameters.put("id", this.feature.getFeatureIdentifier());
        this.parameters.put("version", this.feature.getVersionedIdentifier().getVersion().toString());
        this.parameters.put("label", this.feature.getLabelNonLocalized());
        this.parameters.put("provider-name", this.feature.getProviderNonLocalized());
        this.parameters.put("image", this.feature.getImageURLString());
        this.parameters.put("os", this.feature.getOS());
        this.parameters.put("arch", this.feature.getOSArch());
        this.parameters.put("ws", this.feature.getWS());
        this.parameters.put("nl", this.feature.getNL());
        this.parameters.put("colocation-affinity", this.feature.getAffinityFeature());
        this.parameters.put("primary", new Boolean(this.feature.isPrimary()));
        this.parameters.put("application", this.feature.getApplication());
        this.startTag("feature", this.parameters, true);
    }

    public void printInstallHandler() {
        if (this.feature.getInstallHandlerEntry() == null) {
            return;
        }
        this.parameters.clear();
        this.parameters.put("library", this.feature.getInstallHandlerModel().getLibrary());
        this.parameters.put("handler", this.feature.getInstallHandlerModel().getHandlerName());
        this.startTag("install-handler", this.parameters);
        this.endTag("install-handler");
    }

    public void printDescription() {
        if (this.feature.getDescriptionModel() == null) {
            return;
        }
        this.parameters.clear();
        this.parameters.put("url", this.feature.getDescriptionModel().getURLString());
        this.startTag("description", this.parameters, true);
        this.printTabulation();
        this.println(this.feature.getDescriptionModel().getAnnotationNonLocalized());
        this.endTag("description");
    }

    private void printCopyright() {
        if (this.feature.getCopyrightModel() == null) {
            return;
        }
        this.parameters.clear();
        this.parameters.put("url", this.feature.getCopyrightModel().getURLString());
        this.startTag("copyright", this.parameters, true);
        this.printTabulation();
        this.println(this.feature.getCopyrightModel().getAnnotationNonLocalized());
        this.endTag("copyright");
    }

    public void printLicense() {
        if (this.feature.getLicenseModel() == null) {
            return;
        }
        this.parameters.clear();
        this.parameters.put("url", this.feature.getLicenseModel().getURLString());
        this.startTag("license", this.parameters, true);
        this.printTabulation();
        this.println(this.feature.getLicenseModel().getAnnotationNonLocalized());
        this.endTag("license");
    }

    public void printURL() {
        if (this.feature.getUpdateSiteEntryModel() != null || this.feature.getDiscoverySiteEntryModels().length != 0) {
            this.parameters.clear();
            this.startTag("url", null);
            if (this.feature.getUpdateSiteEntryModel() != null) {
                this.parameters.clear();
                this.parameters.put("url", this.feature.getUpdateSiteEntryModel().getURLString());
                this.parameters.put("label", this.feature.getUpdateSiteEntryModel().getAnnotationNonLocalized());
                this.printTag("update", this.parameters, true, true, true);
            }
            URLEntryModel[] siteEntries = this.feature.getDiscoverySiteEntryModels();
            int i = 0;
            while (i < siteEntries.length) {
                this.parameters.clear();
                this.parameters.put("url", siteEntries[i].getURLString());
                this.parameters.put("label", siteEntries[i].getAnnotationNonLocalized());
                this.printTag("discovery", this.parameters, true, true, true);
                ++i;
            }
            this.endTag("url");
        }
    }

    public void printIncludes() throws CoreException {
        IIncludedFeatureReference[] features = this.feature.getRawIncludedFeatureReferences();
        int i = 0;
        while (i < features.length) {
            this.parameters.clear();
            try {
                this.parameters.put("id", features[i].getVersionedIdentifier().getIdentifier());
                IFeature tmpFeature = this.generator.getSite(false).findFeature(features[i].getVersionedIdentifier().getIdentifier(), null, true);
                this.parameters.put("version", tmpFeature.getVersionedIdentifier().getVersion().toString());
            }
            catch (CoreException coreException) {
                String message = NLS.bind((String)Messages.exception_missingFeature, (Object)features[i].getVersionedIdentifier().getIdentifier());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
            }
            this.printTag("includes", this.parameters, true, true, true);
            ++i;
        }
    }

    private void printRequires() {
        if (this.feature.getImportModels().length == 0) {
            return;
        }
        this.startTag("requires", null);
        this.printImports();
        this.endTag("requires");
    }

    private void printImports() {
        IImport[] imports = this.feature.getRawImports();
        int i = 0;
        while (i < imports.length) {
            this.parameters.clear();
            if (imports[i].getKind() == 0) {
                this.parameters.put("plugin", imports[i].getVersionedIdentifier().getIdentifier());
                this.parameters.put("version", imports[i].getVersionedIdentifier().getVersion().toString());
            } else {
                this.parameters.put("feature", imports[i].getVersionedIdentifier().getIdentifier());
                this.parameters.put("version", imports[i].getVersionedIdentifier().getVersion().toString());
            }
            this.parameters.put("match", this.getStringForMatchingRule(imports[i].getRule()));
            this.printTag("import", this.parameters, true, true, true);
            ++i;
        }
    }

    private String getStringForMatchingRule(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                return "perfect";
            }
            case 2: {
                return "equivalent";
            }
            case 3: {
                return "compatible";
            }
            case 4: {
                return "greaterOrEqual";
            }
        }
        return "";
    }

    public void printPlugins() throws CoreException {
        IPluginEntry[] plugins = this.feature.getRawPluginEntries();
        int i = 0;
        while (i < plugins.length) {
            this.parameters.clear();
            this.parameters.put("id", plugins[i].getVersionedIdentifier().getIdentifier());
            String versionRequested = plugins[i].getVersionedIdentifier().getVersion().toString();
            BundleDescription effectivePlugin = null;
            try {
                effectivePlugin = this.generator.getSite(false).getRegistry().getResolvedBundle(plugins[i].getVersionedIdentifier().getIdentifier(), versionRequested);
            }
            catch (CoreException coreException) {
                String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)plugins[i].getVersionedIdentifier());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
            }
            if (effectivePlugin == null) {
                String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)plugins[i].getVersionedIdentifier());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
            }
            this.parameters.put("version", effectivePlugin.getVersion());
            this.parameters.put("fragment", new Boolean(plugins[i].isFragment()));
            this.parameters.put("os", plugins[i].getOS());
            this.parameters.put("arch", plugins[i].getOSArch());
            this.parameters.put("ws", plugins[i].getWS());
            this.parameters.put("nl", plugins[i].getNL());
            if (plugins[i] instanceof PluginEntry && !((PluginEntry)plugins[i]).isUnpack()) {
                this.parameters.put("unpack", Boolean.FALSE.toString());
            }
            this.parameters.put("download-size", new Long(plugins[i].getDownloadSize() != -1L ? plugins[i].getDownloadSize() : 0L));
            this.parameters.put("install-size", new Long(plugins[i].getInstallSize() != -1L ? plugins[i].getInstallSize() : 0L));
            this.printTag("plugin", this.parameters, true, true, true);
            ++i;
        }
    }

    private void printData() {
        INonPluginEntry[] entries = this.feature.getNonPluginEntries();
        int i = 0;
        while (i < entries.length) {
            this.parameters.put("id", entries[i].getIdentifier());
            this.parameters.put("os", entries[i].getOS());
            this.parameters.put("arch", entries[i].getOSArch());
            this.parameters.put("ws", entries[i].getWS());
            this.parameters.put("nl", entries[i].getNL());
            this.parameters.put("download-size", new Long(entries[i].getDownloadSize() != -1L ? entries[i].getDownloadSize() : 0L));
            this.parameters.put("install-size", new Long(entries[i].getInstallSize() != -1L ? entries[i].getInstallSize() : 0L));
            this.printTag("data", this.parameters, true, true, true);
            ++i;
        }
    }
}

