/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.classpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathGroup;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ClasspathContentProvider
implements ITreeContentProvider {
    private TreeViewer treeViewer;
    private ClasspathModel model = null;
    private boolean refreshEnabled = false;
    private boolean refreshRequested = false;
    private JavaClasspathTab fTab;

    public ClasspathContentProvider(JavaClasspathTab tab) {
        this.fTab = tab;
    }

    public void add(IClasspathEntry parent, IRuntimeClasspathEntry child, Object beforeElement) {
        Object newEntry = null;
        if (parent == null || parent == this.model) {
            newEntry = this.model.addEntry(child);
            parent = this.model;
        } else if (parent instanceof ClasspathGroup) {
            newEntry = this.model.createEntry(child, parent);
            ((ClasspathGroup)parent).addEntry((ClasspathEntry)newEntry, beforeElement);
        }
        if (newEntry != null) {
            this.treeViewer.add((Object)parent, newEntry);
            this.treeViewer.setExpandedState((Object)parent, true);
            this.treeViewer.reveal(newEntry);
            this.refresh();
        }
    }

    public void add(int entryType, IRuntimeClasspathEntry child) {
        Object newEntry = this.model.addEntry(entryType, child);
        if (newEntry != null) {
            this.treeViewer.add(this.getParent(newEntry), newEntry);
            this.refresh();
        }
    }

    public void removeAll() {
        this.model.removeAll();
        this.refresh();
    }

    private void refresh() {
        if (this.refreshEnabled) {
            this.treeViewer.refresh();
            this.refreshRequested = false;
        } else {
            this.refreshRequested = true;
        }
    }

    public void removeAll(IClasspathEntry parent) {
        if (parent instanceof ClasspathGroup) {
            ((ClasspathGroup)parent).removeAll();
        }
        this.refresh();
    }

    public Object getParent(Object element) {
        if (element instanceof ClasspathEntry) {
            return ((ClasspathEntry)element).getParent();
        }
        if (element instanceof ClasspathGroup) {
            return this.model;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ClasspathEntry) {
            return ((ClasspathEntry)element).hasChildren();
        }
        if (element instanceof ClasspathGroup) {
            return ((ClasspathGroup)element).hasEntries();
        }
        if (element instanceof ClasspathModel) {
            return ((ClasspathModel)element).hasEntries();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewer = (TreeViewer)viewer;
        if (newInput != null) {
            this.model = (ClasspathModel)newInput;
        } else {
            if (this.model != null) {
                this.model.removeAll();
            }
            this.model = null;
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ClasspathGroup) {
            return ((ClasspathGroup)parentElement).getEntries();
        }
        if (parentElement instanceof ClasspathModel) {
            return ((ClasspathModel)parentElement).getEntries();
        }
        if (parentElement instanceof ClasspathEntry) {
            return ((ClasspathEntry)parentElement).getChildren(this.fTab.getLaunchConfiguration());
        }
        if (parentElement == null) {
            ArrayList<IClasspathEntry> all = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] topEntries = this.model.getEntries();
            int i = 0;
            while (i < topEntries.length) {
                IClasspathEntry object = topEntries[i];
                if (object instanceof ClasspathEntry) {
                    all.add(object);
                } else if (object instanceof ClasspathGroup) {
                    all.addAll((Collection)Arrays.asList(((ClasspathGroup)object).getEntries()));
                }
                ++i;
            }
            return all.toArray();
        }
        return null;
    }

    public void removeAll(List selection) {
        Object[] array = selection.toArray();
        this.model.removeAll(array);
        this.treeViewer.remove(array);
        this.refresh();
    }

    public IClasspathEntry[] getUserClasspathEntries() {
        return this.model.getEntries(1);
    }

    public IClasspathEntry[] getBootstrapClasspathEntries() {
        return this.model.getEntries(0);
    }

    public void handleMove(boolean direction, IClasspathEntry entry) {
        IClasspathEntry parent = (IClasspathEntry)this.getParent(entry);
        parent.moveChild(direction, entry);
    }

    public ClasspathModel getModel() {
        return this.model;
    }

    public void setRefreshEnabled(boolean refreshEnabled) {
        this.refreshEnabled = refreshEnabled;
        this.treeViewer.getTree().setRedraw(refreshEnabled);
        if (refreshEnabled && this.refreshRequested) {
            this.refresh();
        }
    }

    public void setEntries(IRuntimeClasspathEntry[] entries) {
        this.model.removeAll();
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            switch (entry.getClasspathProperty()) {
                case 3: {
                    this.model.addEntry(1, entry);
                    break;
                }
                default: {
                    this.model.addEntry(0, entry);
                }
            }
            ++i;
        }
        this.refresh();
    }
}

