/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.jres.BuildJREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsComboBlock;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JREContainerWizardPage
extends WizardPage
implements IClasspathContainerPage {
    private IClasspathEntry fSelection;
    private JREsComboBlock fJREBlock;

    public JREContainerWizardPage() {
        super(JREMessages.JREContainerWizardPage_JRE_System_Library_1);
    }

    public boolean finish() {
        IPath path = this.fJREBlock.getPath();
        this.fSelection = JavaCore.newContainerEntry((IPath)path);
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.fSelection;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fSelection = containerEntry;
        this.initializeFromSelection();
    }

    protected void initializeFromSelection() {
        if (this.getControl() != null) {
            if (this.fSelection == null) {
                this.fJREBlock.setUseDefaultJRE();
            } else {
                this.fJREBlock.setPath(this.fSelection.getPath());
                IStatus status = this.fJREBlock.getStatus();
                if (!status.isOK()) {
                    this.setErrorMessage(status.getMessage());
                }
            }
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        this.fJREBlock = new JREsComboBlock();
        this.fJREBlock.setDefaultJREDescriptor(new BuildJREDescriptor());
        this.fJREBlock.setTitle(JREMessages.JREContainerWizardPage_3);
        this.fJREBlock.createControl(composite);
        gd = new GridData(768);
        this.fJREBlock.getControl().setLayoutData((Object)gd);
        this.setControl((Control)composite);
        this.fJREBlock.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IStatus status = JREContainerWizardPage.this.fJREBlock.getStatus();
                if (status.isOK()) {
                    JREContainerWizardPage.this.setErrorMessage(null);
                } else {
                    JREContainerWizardPage.this.setErrorMessage(status.getMessage());
                }
            }
        });
        this.setTitle(JREMessages.JREContainerWizardPage_JRE_System_Library_1);
        this.setMessage(JREMessages.JREContainerWizardPage_Select_the_JRE_used_to_build_this_project__4);
        this.initializeFromSelection();
    }

    public Image getImage() {
        return JavaDebugImages.get("IMG_WIZBAN_LIBRARY");
    }
}

