/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.ui.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.monitors.AsyncMonitorAdapter;
import org.eclipse.jdt.internal.debug.ui.monitors.NoMonitorInformationElement;

public class AsyncJavaThreadAdapter
extends AsyncMonitorAdapter {
    protected Object[] getChildren(Object parent, IPresentationContext context) throws CoreException {
        IJavaThread thread = (IJavaThread)parent;
        if (!thread.isSuspended()) {
            return EMPTY;
        }
        try {
            Object[] children;
            Object[] frames = thread.getStackFrames();
            if (!this.isDisplayMonitors()) {
                return frames;
            }
            int length = frames.length;
            if (((IJavaDebugTarget)thread.getDebugTarget()).supportsMonitorInformation()) {
                IDebugElement[] ownedMonitors = JavaDebugUtils.getOwnedMonitors((IThread)thread);
                IDebugElement contendedMonitor = JavaDebugUtils.getContendedMonitor((IThread)thread);
                if (ownedMonitors != null) {
                    length += ownedMonitors.length;
                }
                if (contendedMonitor != null) {
                    ++length;
                }
                children = new Object[length];
                if (ownedMonitors != null && ownedMonitors.length > 0) {
                    System.arraycopy(ownedMonitors, 0, children, 0, ownedMonitors.length);
                }
                if (contendedMonitor != null) {
                    children[ownedMonitors.length] = contendedMonitor;
                }
            } else {
                children = new Object[length + 1];
                children[0] = new NoMonitorInformationElement(thread.getDebugTarget());
            }
            int offset = children.length - frames.length;
            System.arraycopy(frames, 0, children, offset, frames.length);
            return children;
        }
        catch (DebugException debugException) {
            return EMPTY;
        }
    }

    protected boolean hasChildren(Object element, IPresentationContext context) throws CoreException {
        IJavaThread thread = (IJavaThread)element;
        return thread.hasStackFrames();
    }
}

