/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.team.core.mapping.IStorageMerger;

public final class RefactoringIndexMerger
implements IStreamMerger,
IStorageMerger {
    public boolean canMergeWithoutAncestor() {
        return true;
    }

    public IStatus merge(OutputStream output, String encoding, InputStream ancestor, String ancestorEncoding, InputStream target, String targetEncoding, InputStream source, String sourceEncoding, IProgressMonitor monitor) {
        try {
            this.performMerge(output, encoding, target, source);
        }
        catch (IOException exception) {
            return new Status(4, RefactoringUIPlugin.getPluginId(), 1, RefactoringUIMessages.RefactoringHistoryMerger_error_auto_merge, (Throwable)exception);
        }
        return Status.OK_STATUS;
    }

    public IStatus merge(OutputStream output, String encoding, IStorage ancestor, IStorage target, IStorage source, IProgressMonitor monitor) throws CoreException {
        InputStream sourceStream;
        block29: {
            InputStream targetStream = null;
            sourceStream = null;
            try {
                targetStream = target.getContents();
                sourceStream = target.getContents();
                this.performMerge(output, encoding, targetStream, sourceStream);
            }
            catch (IOException exception) {
                Status status = new Status(4, RefactoringUIPlugin.getPluginId(), 1, RefactoringUIMessages.RefactoringHistoryMerger_error_auto_merge, (Throwable)exception);
                if (targetStream != null) {
                    try {
                        targetStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (sourceStream != null) {
                    try {
                        sourceStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return status;
            }
            catch (CoreException exception) {
                Status status;
                block28: {
                    try {
                        status = new Status(4, RefactoringUIPlugin.getPluginId(), 1, RefactoringUIMessages.RefactoringHistoryMerger_error_auto_merge, (Throwable)exception);
                        if (targetStream == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (targetStream != null) {
                            try {
                                targetStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (sourceStream != null) {
                            try {
                                sourceStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        targetStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (sourceStream != null) {
                    try {
                        sourceStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return status;
            }
            if (targetStream == null) break block29;
            try {
                targetStream.close();
            }
            catch (IOException iOException) {}
        }
        if (sourceStream != null) {
            try {
                sourceStream.close();
            }
            catch (IOException iOException) {}
        }
        return Status.OK_STATUS;
    }

    private void performMerge(OutputStream output, String encoding, InputStream target, InputStream source) throws IOException, UnsupportedEncodingException {
        RefactoringDescriptorProxy[] sourceProxies = RefactoringHistoryManager.readRefactoringDescriptorProxies((InputStream)source, null, (long)0L, (long)Long.MAX_VALUE, (int)0);
        RefactoringDescriptorProxy[] targetProxies = RefactoringHistoryManager.readRefactoringDescriptorProxies((InputStream)target, null, (long)0L, (long)Long.MAX_VALUE, (int)0);
        HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
        int index = 0;
        while (index < sourceProxies.length) {
            set.add(sourceProxies[index]);
            ++index;
        }
        index = 0;
        while (index < targetProxies.length) {
            set.add(targetProxies[index]);
            ++index;
        }
        RefactoringDescriptorProxy[] outputProxies = new RefactoringDescriptorProxy[set.size()];
        set.toArray(outputProxies);
        Arrays.sort(outputProxies, new Comparator(){

            public final int compare(Object first, Object second) {
                RefactoringDescriptorProxy predecessor = (RefactoringDescriptorProxy)first;
                RefactoringDescriptorProxy successor = (RefactoringDescriptorProxy)second;
                long delta = successor.getTimeStamp() - predecessor.getTimeStamp();
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return 0;
            }
        });
        StringBuffer buffer = new StringBuffer(256);
        int index2 = 0;
        while (index2 < outputProxies.length) {
            RefactoringDescriptorProxy proxy = outputProxies[index2];
            buffer.setLength(0);
            buffer.append(proxy.getTimeStamp());
            buffer.append('\t');
            buffer.append(RefactoringHistoryManager.escapeString((String)proxy.getDescription()));
            buffer.append('\n');
            output.write(buffer.toString().getBytes(encoding));
            ++index2;
        }
    }
}

