/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.Calendar;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ResizableDialog;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class AddFromHistoryDialog
extends ResizableDialog {
    private CompareConfiguration fCompareConfiguration;
    private ArrayList fArrayList = new ArrayList();
    private FileHistory fCurrentFileHistory;
    private CompareViewerSwitchingPane fContentPane;
    private Button fCommitButton;
    private Table fMemberTable;
    private CompareViewerPane fMemberPane;
    private Tree fEditionTree;
    private CompareViewerPane fEditionPane;
    private Image fDateImage;
    private Image fTimeImage;

    public AddFromHistoryDialog(Shell parent, ResourceBundle bundle) {
        super(parent, bundle);
        String iconName = Utilities.getString(this.fBundle, "dateIcon", "obj16/day_obj.gif");
        ImageDescriptor id = CompareUIPlugin.getImageDescriptor(iconName);
        if (id != null) {
            this.fDateImage = id.createImage();
        }
        if ((id = CompareUIPlugin.getImageDescriptor(iconName = Utilities.getString(this.fBundle, "timeIcon", "obj16/resource_obj.gif"))) != null) {
            this.fTimeImage = id.createImage();
        }
    }

    public boolean select(IContainer root, IFile[] inputFiles) {
        this.create();
        String format = Utilities.getString(this.fBundle, "memberPaneTitle");
        String title = MessageFormat.format((String)format, (Object[])new Object[]{root.getName()});
        this.fMemberPane.setImage(CompareUI.getImage((IAdaptable)root));
        this.fMemberPane.setText(title);
        int count = inputFiles.length;
        IFile[] files = new IFile[count];
        int i = 0;
        while (i < count) {
            files[i] = inputFiles[i];
            ++i;
        }
        if (count > 1) {
            AddFromHistoryDialog.internalSort(files, 0, count - 1);
        }
        String prefix = root.getFullPath().toString();
        if (this.fMemberTable != null && !this.fMemberTable.isDisposed()) {
            int i2 = 0;
            while (i2 < files.length) {
                IFile file = files[i2];
                String path = file.getFullPath().toString();
                if (path.startsWith(prefix)) {
                    path = path.substring(prefix.length() + 1);
                }
                TableItem ti = new TableItem(this.fMemberTable, 0);
                ti.setImage(CompareUI.getImage((IAdaptable)file));
                ti.setText(path);
                ti.setData((Object)new FileHistory(file));
                ++i2;
            }
        }
        this.open();
        return this.getReturnCode() == 0 && this.fArrayList.size() > 0;
    }

    HistoryInput[] getSelected() {
        HistoryInput[] selected = new HistoryInput[this.fArrayList.size()];
        Iterator iter = this.fArrayList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            FileHistory h = (FileHistory)iter.next();
            selected[i] = h.getHistoryInput();
            ++i;
        }
        return selected;
    }

    protected synchronized Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        this.getShell().setText(Utilities.getString(this.fBundle, "title"));
        Splitter vsplitter = new Splitter(parent, 512);
        vsplitter.setLayoutData(new GridData(1808));
        vsplitter.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AddFromHistoryDialog.this.fDateImage != null) {
                    AddFromHistoryDialog.this.fDateImage.dispose();
                }
                if (AddFromHistoryDialog.this.fTimeImage != null) {
                    AddFromHistoryDialog.this.fTimeImage.dispose();
                }
            }
        });
        Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
        Composite c = new Composite((Composite)hsplitter, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 2;
        layout.numColumns = 1;
        c.setLayout((Layout)layout);
        Label l1 = new Label(c, 0);
        l1.setText(Utilities.getString(this.fBundle, "memberDescription"));
        this.fMemberPane = new CompareViewerPane(c, 0x800800);
        GridData gd = new GridData(1808);
        this.fMemberPane.setLayoutData(gd);
        this.fMemberTable = new Table((Composite)this.fMemberPane, 800);
        this.fMemberTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    if (e.item instanceof TableItem) {
                        TableItem ti = (TableItem)e.item;
                        if (ti.getChecked()) {
                            AddFromHistoryDialog.this.fArrayList.add(ti.getData());
                        } else {
                            AddFromHistoryDialog.this.fArrayList.remove(ti.getData());
                        }
                        if (AddFromHistoryDialog.this.fCommitButton != null) {
                            AddFromHistoryDialog.this.fCommitButton.setEnabled(AddFromHistoryDialog.this.fArrayList.size() > 0);
                        }
                    }
                } else {
                    AddFromHistoryDialog.this.handleMemberSelect(e.item);
                }
            }
        });
        this.fMemberPane.setContent((Control)this.fMemberTable);
        c = new Composite((Composite)hsplitter, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 2;
        layout.numColumns = 1;
        c.setLayout((Layout)layout);
        Label l2 = new Label(c, 0);
        l2.setText(Utilities.getString(this.fBundle, "editionDescription"));
        this.fEditionPane = new CompareViewerPane(c, 0x800800);
        gd = new GridData(1808);
        this.fEditionPane.setLayoutData(gd);
        this.fEditionTree = new Tree((Composite)this.fEditionPane, 768);
        this.fEditionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddFromHistoryDialog.this.feedContent(e.item);
            }
        });
        this.fEditionPane.setContent((Control)this.fEditionTree);
        AddFromHistoryDialog.applyDialogFont((Control)parent);
        this.fContentPane = new CompareViewerSwitchingPane((Composite)vsplitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                return CompareUI.findContentViewer(oldViewer, input, (Composite)this, AddFromHistoryDialog.this.fCompareConfiguration);
            }
        };
        vsplitter.setWeights(new int[]{30, 70});
        return parent;
    }

    private void handleMemberSelect(Widget w) {
        Object data = null;
        if (w != null) {
            data = w.getData();
        }
        if (data instanceof FileHistory) {
            FileHistory h;
            this.fCurrentFileHistory = h = (FileHistory)data;
            IFile file = h.getFile();
            IFileState[] states = h.getStates();
            this.fEditionPane.setImage(CompareUI.getImage((IAdaptable)file));
            String pattern = Utilities.getString(this.fBundle, "treeTitleFormat");
            String title = MessageFormat.format((String)pattern, (Object[])new Object[]{file.getName()});
            this.fEditionPane.setText(title);
            if (this.fEditionTree != null) {
                this.fEditionTree.setRedraw(false);
                this.fEditionTree.removeAll();
                int i = 0;
                while (i < states.length) {
                    this.addEdition(new HistoryInput(file, states[i]), h.isSelected(i));
                    ++i;
                }
                this.fEditionTree.setRedraw(true);
            }
        } else {
            this.fCurrentFileHistory = null;
        }
    }

    private void addEdition(HistoryInput input, boolean isSelected) {
        if (this.fEditionTree == null || this.fEditionTree.isDisposed()) {
            return;
        }
        IFileState state = input.fFileState;
        TreeItem[] days = this.fEditionTree.getItems();
        TreeItem lastDay = null;
        if (days.length > 0) {
            lastDay = days[days.length - 1];
        }
        long ldate = state.getModificationTime();
        long day = this.dayNumber(ldate);
        Date date = new Date(ldate);
        if (lastDay == null || day != this.dayNumber(((Date)lastDay.getData()).getTime())) {
            lastDay = new TreeItem(this.fEditionTree, 0);
            lastDay.setImage(this.fDateImage);
            String df = DateFormat.getDateInstance().format(date);
            long today = this.dayNumber(System.currentTimeMillis());
            String formatKey = day == today ? "todayFormat" : (day == today - 1L ? "yesterdayFormat" : "dayFormat");
            String pattern = Utilities.getString(this.fBundle, formatKey);
            if (pattern != null) {
                df = MessageFormat.format((String)pattern, (Object[])new String[]{df});
            }
            lastDay.setText(df);
            lastDay.setData((Object)date);
        }
        TreeItem ti = new TreeItem(lastDay, 0);
        ti.setImage(this.fTimeImage);
        ti.setText(DateFormat.getTimeInstance().format(date));
        ti.setData((Object)input);
        if (isSelected) {
            lastDay.setExpanded(true);
            this.fEditionTree.setSelection(new TreeItem[]{ti});
            this.feedContent((Widget)ti);
        }
    }

    private long dayNumber(long date) {
        int ONE_DAY_MS = 86400000;
        Calendar calendar = Calendar.getInstance();
        long localTimeOffset = calendar.get(15) + calendar.get(16);
        return (date + localTimeOffset) / (long)ONE_DAY_MS;
    }

    private void feedContent(Widget w) {
        if (this.fContentPane != null && !this.fContentPane.isDisposed()) {
            Object o = w.getData();
            if (o instanceof HistoryInput) {
                HistoryInput selected = (HistoryInput)o;
                this.fContentPane.setInput(selected);
                this.fContentPane.setText(this.getEditionLabel(selected));
                this.fContentPane.setImage(this.fTimeImage);
                if (this.fCurrentFileHistory != null) {
                    this.fCurrentFileHistory.setSelected(selected.fFileState);
                }
            } else {
                this.fContentPane.setInput(null);
            }
        }
    }

    protected String getEditionLabel(HistoryInput input) {
        String format = Utilities.getString(this.fBundle, "historyEditionLabel", null);
        if (format == null) {
            format = Utilities.getString(this.fBundle, "editionLabel");
        }
        if (format == null) {
            format = "x{0}";
        }
        long modDate = input.getModificationDate();
        String date = DateFormat.getDateTimeInstance().format(new Date(modDate));
        return MessageFormat.format((String)format, (Object[])new Object[]{date});
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String buttonLabel = Utilities.getString(this.fBundle, "buttonLabel", IDialogConstants.OK_LABEL);
        this.fCommitButton = this.createButton(parent, 0, buttonLabel, true);
        this.fCommitButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private static boolean greaterThan(IFile f1, IFile f2) {
        String[] ss1 = f1.getFullPath().segments();
        String[] ss2 = f2.getFullPath().segments();
        int l1 = ss1.length;
        int l2 = ss2.length;
        int n = Math.max(l1, l2);
        int i = 0;
        while (i < n) {
            String s2;
            String s1 = i < l1 ? ss1[i] : "";
            int rc = s1.compareToIgnoreCase(s2 = i < l2 ? ss2[i] : "");
            if (rc != 0) {
                return rc < 0;
            }
            ++i;
        }
        return false;
    }

    private static void internalSort(IFile[] keys, int left, int right) {
        int original_left = left;
        int original_right = right;
        IFile mid = keys[(left + right) / 2];
        while (true) {
            if (AddFromHistoryDialog.greaterThan(keys[left], mid)) {
                ++left;
                continue;
            }
            while (AddFromHistoryDialog.greaterThan(mid, keys[right])) {
                --right;
            }
            if (left <= right) {
                IFile tmp = keys[left];
                keys[left] = keys[right];
                keys[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            AddFromHistoryDialog.internalSort(keys, original_left, right);
        }
        if (left < original_right) {
            AddFromHistoryDialog.internalSort(keys, left, original_right);
        }
    }

    static class HistoryInput
    implements ITypedElement,
    IEncodedStreamContentAccessor,
    IModificationDate {
        IFile fFile;
        IFileState fFileState;

        HistoryInput(IFile file, IFileState fileState) {
            this.fFile = file;
            this.fFileState = fileState;
        }

        public InputStream getContents() throws CoreException {
            return new BufferedInputStream(this.fFileState.getContents());
        }

        public String getCharset() {
            String charset = null;
            try {
                charset = this.fFileState.getCharset();
            }
            catch (CoreException coreException) {}
            if (charset == null) {
                charset = Utilities.getCharset((IResource)this.fFile);
            }
            return charset;
        }

        public String getName() {
            return this.fFile.getName();
        }

        public String getType() {
            return this.fFile.getFileExtension();
        }

        public Image getImage() {
            return CompareUI.getImage((IAdaptable)this.fFile);
        }

        public long getModificationDate() {
            return this.fFileState.getModificationTime();
        }
    }

    static class FileHistory {
        private IFile fFile;
        private IFileState[] fStates;
        private int fSelected;

        FileHistory(IFile file) {
            this.fFile = file;
        }

        IFile getFile() {
            return this.fFile;
        }

        IFileState[] getStates() {
            if (this.fStates == null) {
                try {
                    this.fStates = this.fFile.getHistory((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
            return this.fStates;
        }

        IFileState getSelectedState() {
            return this.getStates()[this.fSelected];
        }

        void setSelected(IFileState state) {
            int i = 0;
            while (i < this.fStates.length) {
                if (this.fStates[i] == state) {
                    this.fSelected = i;
                    return;
                }
                ++i;
            }
        }

        HistoryInput getHistoryInput() {
            return new HistoryInput(this.fFile, this.getSelectedState());
        }

        boolean isSelected(int index) {
            return index == this.fSelected;
        }
    }
}

