/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Hashtable;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleStopper {
    private Hashtable stoppedBundles;
    private BundleDescription[] allToStop = null;
    private BundleContext context;
    private FrameworkAdaptor adaptor;
    private boolean stopping;

    public BundleStopper(BundleContext context, FrameworkAdaptor adaptor) {
        this.context = context;
        this.adaptor = adaptor;
    }

    private void logCycles(Object[][] cycles) {
        if (!Debug.DEBUG_ENABLED) {
            return;
        }
        if (cycles.length > 0) {
            StringBuffer cycleText = new StringBuffer("[");
            int i = 0;
            while (i < cycles.length) {
                cycleText.append('[');
                int j = 0;
                while (j < cycles[i].length) {
                    cycleText.append(((BundleDescription)cycles[i][j]).getSymbolicName());
                    cycleText.append(',');
                    ++j;
                }
                cycleText.insert(cycleText.length() - 1, ']');
                ++i;
            }
            cycleText.setCharAt(cycleText.length() - 1, ']');
            String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_BUNDLESTOPPER_CYCLES_FOUND, cycleText);
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 2, 0, message, 0, null, null);
            this.adaptor.getFrameworkLog().log(entry);
        }
    }

    public void stopBundles() {
        this.allToStop = this.adaptor.getState().getResolvedBundles();
        StateHelper stateHelper = this.adaptor.getPlatformAdmin().getStateHelper();
        Object[][] cycles = stateHelper.sortBundles(this.allToStop);
        this.logCycles(cycles);
        this.stoppedBundles = new Hashtable(this.allToStop.length);
        this.basicStopBundles();
    }

    private void basicStopBundles() {
        this.stopping = true;
        int stoppingIndex = this.allToStop.length - 1;
        while (stoppingIndex >= 0) {
            AbstractBundle toStop = (AbstractBundle)this.context.getBundle(this.allToStop[stoppingIndex].getBundleId());
            BaseData bundledata = (BaseData)toStop.getBundleData();
            EclipseStorageHook storageHook = (EclipseStorageHook)bundledata.getStorageHook(EclipseStorageHook.KEY);
            if (toStop.getBundleId() != 0L && storageHook != null && storageHook.isAutoStartable()) {
                try {
                    try {
                        if (toStop.getState() == 32 && toStop instanceof BundleHost) {
                            toStop.stop();
                            if (!storageHook.isActivatedOnClassLoad()) {
                                bundledata.setStatus(1);
                            }
                        }
                    }
                    catch (Exception e) {
                        String message = NLS.bind(EclipseAdaptorMsg.ECLIPSE_BUNDLESTOPPER_ERROR_STOPPING_BUNDLE, this.allToStop[stoppingIndex].toString());
                        FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", 4, 0, message, 0, e, null);
                        this.adaptor.getFrameworkLog().log(entry);
                    }
                }
                finally {
                    this.stoppedBundles.put(toStop, toStop);
                }
            }
            --stoppingIndex;
        }
        this.stopping = false;
    }

    public boolean isStopped(Bundle bundle) {
        if (this.stoppedBundles == null) {
            return false;
        }
        return this.stoppedBundles.get(bundle) != null;
    }

    public boolean isStopping() {
        return this.stopping;
    }
}

