/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.AbstractUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.AsynchronousModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeModel;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.viewers.LabelResult;
import org.eclipse.debug.internal.ui.viewers.ModelNode;
import org.eclipse.debug.internal.ui.viewers.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.TreeEditorImpl;
import org.eclipse.debug.internal.ui.viewers.TreeUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousLabelAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IColumnEditor;
import org.eclipse.debug.internal.ui.viewers.provisional.IColumnEditorFactoryAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.provisional.IColumnPresentationFactoryAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.progress.WorkbenchJob;

public class AsynchronousTreeViewer
extends AsynchronousViewer {
    private Tree fTree;
    private TreeEditorImpl fTreeEditorImpl;
    private TreeEditor fTreeEditor;
    private List fPendingExpansion = new ArrayList();
    private IColumnPresentation fColumnPresentation = null;
    private IColumnEditor fColumnEditor = null;
    private Map fVisibleColumns = new HashMap();
    private Map fColumnSizes = new HashMap();
    private Map fColumnOrder = new HashMap();
    private Map fShowColumns = new HashMap();
    private static final String COLUMN_SIZES = "COLUMN_SIZES";
    private static final String COLUMN_ORDER = "COLUMN_ORDER";
    private static final String VISIBLE_COLUMNS = "VISIBLE_COLUMNS";
    private static final String SHOW_COLUMNS = "SHOW_COLUMNS";
    private static final String SIZE = "SIZE";
    private static final String COLUMN = "COLUMN";
    private ColumnListener fListener = new ColumnListener();

    public AsynchronousTreeViewer(Composite parent) {
        this(parent, 268436226);
    }

    public AsynchronousTreeViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    public AsynchronousTreeViewer(Tree tree) {
        Assert.isTrue(((tree.getStyle() & 0x10000000) != 0 ? 1 : 0) != 0);
        this.fTree = tree;
        this.hookControl((Control)this.fTree);
        this.fTreeEditor = new TreeEditor(tree);
        this.initTreeViewerImpl();
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Tree tree = (Tree)control;
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem treeItem;
                Item[] items;
                if (AsynchronousTreeViewer.this.isShowColumns() && (items = AsynchronousTreeViewer.this.fTreeEditorImpl.getSelection()).length > 0 && (treeItem = (TreeItem)items[0]) != null) {
                    Object element = treeItem.getData();
                    AsynchronousTreeViewer.this.updateColumnEditor(element);
                    if (AsynchronousTreeViewer.this.fColumnEditor != null) {
                        int columnToEdit = -1;
                        int columns = AsynchronousTreeViewer.this.fTree.getColumnCount();
                        if (columns == 0) {
                            columnToEdit = 0;
                        } else {
                            columnToEdit = -1;
                            int i = 0;
                            while (i < columns) {
                                Rectangle bounds = AsynchronousTreeViewer.this.fTreeEditorImpl.getBounds((Item)treeItem, i);
                                if (bounds.contains(e.x, e.y)) {
                                    columnToEdit = i;
                                    break;
                                }
                                ++i;
                            }
                            if (columnToEdit == -1) {
                                return;
                            }
                        }
                        CellEditor cellEditor = AsynchronousTreeViewer.this.fColumnEditor.getCellEditor(AsynchronousTreeViewer.this.getVisibleColumns()[columnToEdit], element, (Composite)AsynchronousTreeViewer.this.fTree);
                        if (cellEditor == null) {
                            return;
                        }
                        AsynchronousTreeViewer.this.disposeCellEditors();
                        CellEditor[] newEditors = new CellEditor[columns];
                        newEditors[columnToEdit] = cellEditor;
                        AsynchronousTreeViewer.this.setCellEditors(newEditors);
                        AsynchronousTreeViewer.this.setCellModifier(AsynchronousTreeViewer.this.fColumnEditor.getCellModifier());
                        AsynchronousTreeViewer.this.setColumnProperties(AsynchronousTreeViewer.this.getVisibleColumns());
                    }
                }
                AsynchronousTreeViewer.this.fTreeEditorImpl.handleMouseDown(e);
            }
        });
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                ModelNode node = AsynchronousTreeViewer.this.findNode(e.item);
                if (node != null) {
                    AsynchronousTreeViewer.this.internalRefresh(node);
                }
            }

            public void treeCollapsed(TreeEvent e) {
            }
        });
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item = ((Tree)e.widget).getItem(new Point(e.x, e.y));
                if (item != null) {
                    if (item.getExpanded()) {
                        item.setExpanded(false);
                    } else {
                        item.setExpanded(true);
                        ModelNode node = AsynchronousTreeViewer.this.findNode((Widget)item);
                        if (node != null) {
                            AsynchronousTreeViewer.this.internalRefresh(node);
                        }
                    }
                }
            }
        });
    }

    protected void updateColumnEditor(Object element) {
        IColumnEditorFactoryAdapter factoryAdapter = this.getColumnEditorFactoryAdapter(element);
        if (factoryAdapter != null) {
            if (this.fColumnEditor != null) {
                if (this.fColumnEditor.getId().equals(factoryAdapter.getColumnEditorId(this.getPresentationContext(), element))) {
                    return;
                }
                this.fColumnEditor.dispose();
            }
            this.fColumnEditor = factoryAdapter.createColumnEditor(this.getPresentationContext(), element);
            if (this.fColumnEditor != null) {
                this.fColumnEditor.init(this.getPresentationContext());
            }
        } else if (this.fColumnEditor != null) {
            this.fColumnEditor.dispose();
            this.fColumnEditor = null;
        }
    }

    public Tree getTree() {
        return this.fTree;
    }

    protected void updateHasChildren(ModelNode node) {
        ((AsynchronousTreeModel)this.getModel()).updateHasChildren(node);
    }

    public synchronized void expand(ISelection selection) {
        if (selection instanceof TreeSelection) {
            TreePath[] paths = ((TreeSelection)selection).getPaths();
            int i = 0;
            while (i < paths.length) {
                this.fPendingExpansion.add(paths[i]);
                ++i;
            }
            if (this.getControl().getDisplay().getThread() == Thread.currentThread()) {
                this.attemptExpansion();
            } else {
                WorkbenchJob job = new WorkbenchJob("attemptExpansion"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AsynchronousTreeViewer.this.attemptExpansion();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    synchronized void attemptExpansion() {
        if (this.fPendingExpansion != null) {
            Iterator i = this.fPendingExpansion.iterator();
            while (i.hasNext()) {
                TreePath path = (TreePath)i.next();
                if (!this.attemptExpansion(path)) continue;
                i.remove();
            }
        }
    }

    synchronized boolean attemptExpansion(TreePath path) {
        int segmentCount = path.getSegmentCount();
        int j = segmentCount - 1;
        while (j >= 0) {
            Object element = path.getSegment(j);
            ModelNode[] nodes = this.getModel().getNodes(element);
            if (nodes != null) {
                int k = 0;
                while (k < nodes.length) {
                    ModelNode node = nodes[k];
                    TreePath treePath = node.getTreePath();
                    if (path.startsWith(treePath, null) && !node.isDisposed()) {
                        Widget widget = this.findItem(node);
                        if (widget == null) {
                            ModelNode parent = node.getParentNode();
                            ModelNode child = node;
                            widget = this.findItem(parent);
                            while (widget == null && parent != null) {
                                child = parent;
                                if ((parent = parent.getParentNode()) == null) continue;
                                widget = this.findItem(parent);
                                treePath = parent.getTreePath();
                            }
                            int childIndex = parent.getChildIndex(child);
                            if (childIndex < 0) {
                                return false;
                            }
                            TreeItem[] items = this.getItems(widget);
                            if (childIndex < items.length) {
                                widget = items[childIndex];
                                this.mapElement(child, widget);
                                widget.setData(child.getElement());
                                treePath = child.getTreePath();
                                node = child;
                            } else {
                                return false;
                            }
                        }
                        if (widget instanceof TreeItem && !widget.isDisposed()) {
                            TreeItem treeItem = (TreeItem)widget;
                            if (treeItem.getExpanded()) {
                                return path.getSegmentCount() == treePath.getSegmentCount();
                            }
                            if (treeItem.getItemCount() > 0) {
                                this.updateChildren(node);
                                this.expand(treeItem);
                                return path.getSegmentCount() == treePath.getSegmentCount();
                            }
                            this.updateHasChildren(node);
                            return false;
                        }
                    }
                    ++k;
                }
            }
            --j;
        }
        return false;
    }

    public Control getControl() {
        return this.fTree;
    }

    public synchronized void dispose() {
        if (this.fColumnPresentation != null) {
            this.fColumnPresentation.dispose();
        }
        this.disposeCellEditors();
        if (this.fColumnEditor != null) {
            this.fColumnEditor.dispose();
        }
        super.dispose();
    }

    protected void disposeCellEditors() {
        CellEditor[] cellEditors = this.getCellEditors();
        if (cellEditors != null) {
            int i = 0;
            while (i < cellEditors.length) {
                CellEditor editor = cellEditors[i];
                if (editor != null) {
                    editor.dispose();
                }
                ++i;
            }
        }
        this.setCellEditors(null);
    }

    protected synchronized void inputChanged(Object input, Object oldInput) {
        this.fPendingExpansion.clear();
        super.inputChanged(input, oldInput);
        this.resetColumns(input);
    }

    public void refreshColumns() {
        this.configureColumns();
        this.refresh();
    }

    protected void resetColumns(Object input) {
        if (input != null) {
            IColumnPresentationFactoryAdapter factory = this.getColumnPresenetationFactoryAdapter(input);
            PresentationContext context = (PresentationContext)this.getPresentationContext();
            String type = null;
            if (factory != null) {
                type = factory.getColumnPresentationId(context, input);
            }
            if (type != null) {
                if (this.fColumnPresentation != null && !this.fColumnPresentation.getId().equals(type)) {
                    this.fColumnPresentation.dispose();
                    this.fColumnPresentation = null;
                }
                if (this.fColumnPresentation == null) {
                    this.fColumnPresentation = factory.createColumnPresentation(context, input);
                    if (this.fColumnPresentation != null) {
                        this.fColumnPresentation.init(context);
                        this.configureColumns();
                    }
                }
            } else if (this.fColumnPresentation != null) {
                this.fColumnPresentation.dispose();
                this.fColumnPresentation = null;
                this.configureColumns();
            }
        }
    }

    protected void configureColumns() {
        if (this.fColumnPresentation != null) {
            IColumnPresentation build = null;
            if (this.isShowColumns(this.fColumnPresentation.getId())) {
                build = this.fColumnPresentation;
            }
            this.buildColumns(build);
        } else {
            this.buildColumns(null);
        }
    }

    protected void buildColumns(IColumnPresentation presentation) {
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        String[] visibleColumnIds = this.getVisibleColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            treeColumn.removeControlListener((ControlListener)this.fListener);
            treeColumn.dispose();
            ++i;
        }
        PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
        if (presentation != null) {
            int i2 = 0;
            while (i2 < visibleColumnIds.length) {
                String id = visibleColumnIds[i2];
                String header = presentation.getHeader(id);
                TreeColumn column = new TreeColumn(tree, 16384, i2);
                column.setMoveable(true);
                column.setText(header);
                column.setWidth(1);
                ImageDescriptor image = presentation.getImageDescriptor(id);
                if (image != null) {
                    column.setImage(this.getImage(image));
                }
                column.setData((Object)id);
                ++i2;
            }
            int[] order = (int[])this.fColumnOrder.get(presentation.getId());
            if (order != null) {
                tree.setColumnOrder(order);
            }
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            presentationContext.setColumns(this.getVisibleColumns());
        } else {
            tree.setHeaderVisible(false);
            tree.setLinesVisible(false);
            presentationContext.setColumns(null);
        }
        int avg = tree.getSize().x;
        if (visibleColumnIds != null) {
            avg /= visibleColumnIds.length;
        }
        if (avg == 0) {
            tree.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Tree tree2 = AsynchronousTreeViewer.this.getTree();
                    String[] visibleColumns = AsynchronousTreeViewer.this.getVisibleColumns();
                    if (visibleColumns != null) {
                        int avg1 = tree2.getSize().x / visibleColumns.length;
                        AsynchronousTreeViewer.this.initColumns(avg1);
                    }
                    tree2.removePaintListener((PaintListener)this);
                }
            });
        } else {
            this.initColumns(avg);
        }
    }

    private void initColumns(int widthHint) {
        TreeColumn[] columns = this.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            Integer width = (Integer)this.fColumnSizes.get(treeColumn.getData());
            if (width == null) {
                treeColumn.setWidth(widthHint);
            } else {
                treeColumn.setWidth(width.intValue());
            }
            treeColumn.addControlListener((ControlListener)this.fListener);
            ++i;
        }
    }

    protected void persistColumnSizes() {
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            Object id = treeColumn.getData();
            this.fColumnSizes.put(id, new Integer(treeColumn.getWidth()));
            ++i;
        }
    }

    protected void persistColumnOrder() {
        IColumnPresentation presentation = this.getColumnPresentation();
        if (presentation != null) {
            Tree tree = this.getTree();
            int[] order = tree.getColumnOrder();
            if (order.length > 0) {
                int i = 0;
                while (i < order.length) {
                    if (i != order[i]) {
                        this.fColumnOrder.put(presentation.getId(), order);
                        return;
                    }
                    ++i;
                }
            }
            this.fColumnOrder.remove(presentation.getId());
        }
    }

    protected IColumnPresentationFactoryAdapter getColumnPresenetationFactoryAdapter(Object input) {
        if (input instanceof IColumnPresentationFactoryAdapter) {
            return (IColumnPresentationFactoryAdapter)input;
        }
        if (input instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)input;
            return (IColumnPresentationFactoryAdapter)adaptable.getAdapter(IColumnPresentationFactoryAdapter.class);
        }
        return null;
    }

    protected IColumnEditorFactoryAdapter getColumnEditorFactoryAdapter(Object input) {
        if (input instanceof IColumnEditorFactoryAdapter) {
            return (IColumnEditorFactoryAdapter)input;
        }
        if (input instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)input;
            return (IColumnEditorFactoryAdapter)adaptable.getAdapter(IColumnEditorFactoryAdapter.class);
        }
        return null;
    }

    protected synchronized TreePath getTreePath(TreeItem item) {
        TreeItem parent = item;
        ArrayList<Object> path = new ArrayList<Object>();
        while (parent != null && !parent.isDisposed()) {
            Object parentElement = parent.getData();
            if (parentElement == null) {
                parent.getItemCount();
                parentElement = parent.getData();
                if (parentElement == null) {
                    return null;
                }
            }
            path.add(0, parentElement);
            parent = parent.getParentItem();
        }
        Object data = this.fTree.getData();
        if (data == null) {
            return null;
        }
        path.add(0, data);
        return new TreePath(path.toArray());
    }

    public TreePath[] getTreePaths(Object element) {
        ModelNode[] nodes = this.getModel().getNodes(element);
        if (nodes == null) {
            return new TreePath[0];
        }
        TreePath[] paths = new TreePath[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            paths[i] = nodes[i].getTreePath();
            ++i;
        }
        return paths;
    }

    protected int getItemCount(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItemCount();
        }
        return ((Tree)widget).getItemCount();
    }

    protected void setItemCount(Widget widget, int itemCount) {
        if (widget == this.fTree) {
            this.fTree.setItemCount(itemCount);
        } else {
            ((TreeItem)widget).setItemCount(itemCount);
        }
    }

    protected Widget getChildWidget(Widget parent, int index) {
        TreeItem item;
        if (parent instanceof Tree) {
            Tree tree = (Tree)parent;
            if (index < tree.getItemCount()) {
                return tree.getItem(index);
            }
        } else if (parent instanceof TreeItem && index < (item = (TreeItem)parent).getItemCount()) {
            return item.getItem(index);
        }
        return null;
    }

    private TreeItem[] getItems(Widget widget) {
        if (widget instanceof TreeItem) {
            return ((TreeItem)widget).getItems();
        }
        return this.fTree.getItems();
    }

    protected Widget getParentWidget(Widget widget) {
        if (widget instanceof TreeItem) {
            TreeItem parentItem = ((TreeItem)widget).getParentItem();
            if (parentItem == null) {
                return this.getControl();
            }
            return parentItem;
        }
        return null;
    }

    private void expand(TreeItem child) {
        if (!child.getExpanded()) {
            child.setExpanded(true);
            TreeItem parent = child.getParentItem();
            if (parent != null) {
                this.expand(parent);
            }
        }
    }

    protected void clear(Widget widget) {
        if (DEBUG_VIEWER) {
            DebugUIPlugin.debug("CLEAR [" + widget + "]");
        }
        if (widget instanceof TreeItem && !widget.isDisposed()) {
            TreeItem item = (TreeItem)widget;
            TreeItem parentItem = item.getParentItem();
            if (parentItem == null) {
                int index = this.fTree.indexOf(item);
                if (index >= 0) {
                    this.fTree.clear(index, true);
                }
            } else {
                int index = parentItem.indexOf(item);
                if (index >= 0) {
                    parentItem.clear(index, true);
                }
            }
            item.clearAll(true);
        } else {
            this.fTree.clearAll(true);
        }
    }

    protected void clearChildren(Widget widget) {
        if (DEBUG_VIEWER) {
            DebugUIPlugin.debug("CLEAR_CHILDREN [" + widget + "]");
        }
        if (widget instanceof TreeItem && !widget.isDisposed()) {
            TreeItem item = (TreeItem)widget;
            int itemCount = item.getItemCount();
            int i = 0;
            while (i < itemCount) {
                item.clear(i, false);
                ++i;
            }
        } else {
            int itemCount = this.fTree.getItemCount();
            int i = 0;
            while (i < itemCount) {
                this.fTree.clear(i, false);
                ++i;
            }
        }
    }

    protected void clearChild(Widget parent, int childIndex) {
        if (DEBUG_VIEWER) {
            DebugUIPlugin.debug("CLEAR_CHILD [" + parent + "]: " + childIndex);
        }
        if (parent instanceof TreeItem && !parent.isDisposed()) {
            TreeItem item = (TreeItem)parent;
            item.clear(childIndex, false);
        } else {
            this.fTree.clear(childIndex, false);
        }
    }

    protected ISelection newSelectionFromWidget() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        List list = this.getSelectionFromWidget();
        return new TreeSelection(list.toArray(new TreePath[list.size()]));
    }

    protected synchronized List getSelectionFromWidget() {
        TreeItem[] selection = this.fTree.getSelection();
        ArrayList<TreePath> paths = new ArrayList<TreePath>(selection.length);
        int i = 0;
        while (i < selection.length) {
            TreePath treePath = this.getTreePath(selection[i]);
            if (treePath != null) {
                paths.add(treePath);
            }
            ++i;
        }
        return paths;
    }

    protected void internalRefresh(ModelNode node) {
        super.internalRefresh(node);
        this.updateHasChildren(node);
    }

    public void reveal(Object element) {
        ModelNode[] nodes = this.getModel().getNodes(element);
        if (nodes != null) {
            int i = 0;
            while (i < nodes.length) {
                ModelNode node = nodes[i];
                Widget widget = this.findItem(node);
                if (widget instanceof TreeItem) {
                    TreeItem item = (TreeItem)widget;
                    Tree tree = (Tree)this.getControl();
                    tree.showItem(item);
                    return;
                }
                ++i;
            }
        }
    }

    protected synchronized ISelection doAttemptSelectionToWidget(ISelection selection, boolean reveal) {
        ArrayList<TreePath> remaining = new ArrayList<TreePath>();
        if (!selection.isEmpty()) {
            ArrayList<Widget> toSelect = new ArrayList<Widget>();
            ArrayList<ModelNode> theNodes = new ArrayList<ModelNode>();
            ArrayList<Object> theElements = new ArrayList<Object>();
            TreeSelection treeSelection = (TreeSelection)selection;
            TreePath[] paths = treeSelection.getPaths();
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                if (path != null) {
                    ModelNode[] nodes = this.getModel().getNodes(path.getLastSegment());
                    boolean selected = false;
                    if (nodes != null) {
                        int j = 0;
                        while (j < nodes.length) {
                            Widget widget;
                            Widget widget2;
                            ModelNode node = nodes[j];
                            if (node.correspondsTo(path) && (widget2 = this.findItem(node)) != null && !widget2.isDisposed()) {
                                toSelect.add(widget2);
                                theNodes.add(node);
                                theElements.add(path.getLastSegment());
                                selected = true;
                                break;
                            }
                            ModelNode parent = node.getParentNode();
                            ModelNode child = node;
                            if (parent != null && (widget = this.findItem(parent)) != null && !widget.isDisposed()) {
                                TreeItem[] items;
                                int childIndex = parent.getChildIndex(child);
                                if (childIndex < 0 || childIndex >= (items = this.getItems(widget)).length) break;
                                widget = items[childIndex];
                                this.mapElement(child, widget);
                                widget.setData(child.getElement());
                                toSelect.add(widget);
                                theNodes.add(child);
                                theElements.add(child.getElement());
                                selected = true;
                            }
                            ++j;
                        }
                    }
                    if (!selected) {
                        remaining.add(path);
                    }
                }
                ++i;
            }
            if (!toSelect.isEmpty()) {
                TreeItem[] items = toSelect.toArray(new TreeItem[toSelect.size()]);
                int i2 = 0;
                while (i2 < items.length) {
                    TreeItem item = items[i2];
                    Object element = theElements.get(i2);
                    if (!item.isDisposed() && item.getData() != element) {
                        ModelNode theNode = (ModelNode)theNodes.get(i2);
                        Widget mapped = this.findItem(theNode);
                        if (mapped == null) {
                            return selection;
                        }
                        theNode.remap(element);
                        item.setData(element);
                    }
                    ++i2;
                }
                this.fTree.setSelection(items);
                if (reveal) {
                    this.fTree.showItem(items[0]);
                }
            }
        } else {
            this.fTree.setSelection(new TreeItem[0]);
        }
        return new TreeSelection(remaining.toArray(new TreePath[remaining.size()]));
    }

    public void collapseAll() {
        TreeItem[] items = this.fTree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item.getExpanded()) {
                this.collapse(item);
            }
            ++i;
        }
    }

    protected void collapse(TreeItem item) {
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem child = items[i];
            if (child.getExpanded()) {
                this.collapse(child);
            }
            ++i;
        }
        item.setExpanded(false);
    }

    protected void setColors(Widget widget, RGB[] foregrounds, RGB[] backgrounds) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            Color[] fgs = this.getColors(foregrounds);
            int i = 0;
            while (i < fgs.length) {
                item.setForeground(i, fgs[i]);
                ++i;
            }
            Color[] bgs = this.getColors(backgrounds);
            int i2 = 0;
            while (i2 < bgs.length) {
                item.setBackground(i2, bgs[i2]);
                ++i2;
            }
        }
    }

    protected void setFonts(Widget widget, FontData[] fontData) {
        if (widget instanceof TreeItem) {
            TreeItem item = (TreeItem)widget;
            Font[] fonts = this.getFonts(fontData);
            int i = 0;
            while (i < fonts.length) {
                item.setFont(i, fonts[i]);
                ++i;
            }
        }
    }

    protected boolean acceptsSelection(ISelection selection) {
        return selection instanceof TreeSelection;
    }

    protected ISelection getEmptySelection() {
        return new TreeSelection(new TreePath[0]);
    }

    public void add(TreePath treePath) {
        ((AsynchronousTreeModel)this.getModel()).add(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TreePath treePath) {
        AsynchronousTreeViewer asynchronousTreeViewer = this;
        synchronized (asynchronousTreeViewer) {
            Iterator i = this.fPendingExpansion.iterator();
            while (i.hasNext()) {
                TreePath expansionPath = (TreePath)i.next();
                if (!expansionPath.startsWith(treePath, null)) continue;
                i.remove();
            }
        }
        ((AsynchronousTreeModel)this.getModel()).remove(treePath);
    }

    protected void restoreLabels(Item item) {
        TreeItem treeItem = (TreeItem)item;
        String[] values = (String[])treeItem.getData("old_label");
        Image[] images = (Image[])treeItem.getData("old_image");
        if (values != null) {
            treeItem.setText(values);
            treeItem.setImage(images);
        }
    }

    protected void setLabels(Widget widget, String[] text, ImageDescriptor[] image) {
        TreeItem item;
        if (widget instanceof TreeItem && !(item = (TreeItem)widget).isDisposed()) {
            item.setText(text);
            item.setData("old_label", (Object)text);
            Image[] images = this.getImages(image);
            item.setImage(images);
            item.setData("old_image", (Object)images);
        }
    }

    protected AsynchronousModel createModel() {
        return new AsynchronousTreeModel(this);
    }

    protected void attemptPendingUpdates() {
        this.attemptExpansion();
        super.attemptPendingUpdates();
    }

    public AbstractUpdatePolicy createUpdatePolicy() {
        return new TreeUpdatePolicy();
    }

    protected synchronized void unmapAllElements() {
        super.unmapAllElements();
        Tree tree = this.getTree();
        if (!tree.isDisposed()) {
            TreeItem[] items = tree.getItems();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
            this.clear((Widget)tree);
        }
    }

    public IColumnPresentation getColumnPresentation() {
        return this.fColumnPresentation;
    }

    public String[] getVisibleColumns() {
        IColumnPresentation presentation = this.getColumnPresentation();
        if (presentation != null) {
            String[] columns = (String[])this.fVisibleColumns.get(presentation.getId());
            if (columns == null) {
                return presentation.getInitialColumns();
            }
            return columns;
        }
        return null;
    }

    public void setVisibleColumns(String[] ids) {
        IColumnPresentation presentation = this.getColumnPresentation();
        if (presentation != null) {
            this.fColumnOrder.remove(presentation.getId());
            this.fVisibleColumns.remove(presentation.getId());
            if (ids != null) {
                String[] columns = presentation.getInitialColumns();
                if (columns.length == ids.length) {
                    int i = 0;
                    while (i < columns.length) {
                        if (!ids[i].equals(columns[i])) {
                            this.fVisibleColumns.put(presentation.getId(), ids);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.fVisibleColumns.put(presentation.getId(), ids);
                }
            }
            PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
            presentationContext.setColumns(this.getVisibleColumns());
            this.refreshColumns();
        }
    }

    public void saveState(IMemento memento) {
        int i;
        String id;
        IMemento sizes;
        if (!this.fColumnSizes.isEmpty()) {
            for (Map.Entry entry : this.fColumnSizes.entrySet()) {
                sizes = memento.createChild(COLUMN_SIZES, (String)entry.getKey());
                sizes.putInteger(SIZE, ((Integer)entry.getValue()).intValue());
            }
        }
        if (!this.fShowColumns.isEmpty()) {
            for (Map.Entry entry : this.fShowColumns.entrySet()) {
                sizes = memento.createChild(SHOW_COLUMNS, (String)entry.getKey());
                sizes.putString(SHOW_COLUMNS, ((Boolean)entry.getValue()).toString());
            }
        }
        if (!this.fVisibleColumns.isEmpty()) {
            for (Map.Entry entry : this.fVisibleColumns.entrySet()) {
                id = (String)entry.getKey();
                IMemento visible = memento.createChild(VISIBLE_COLUMNS, id);
                String[] columns = (String[])entry.getValue();
                visible.putInteger(SIZE, columns.length);
                i = 0;
                while (i < columns.length) {
                    visible.putString(COLUMN + Integer.toString(i), columns[i]);
                    ++i;
                }
            }
        }
        if (!this.fColumnOrder.isEmpty()) {
            for (Map.Entry entry : this.fColumnOrder.entrySet()) {
                id = (String)entry.getKey();
                IMemento orderMemento = memento.createChild(COLUMN_ORDER, id);
                int[] order = (int[])entry.getValue();
                orderMemento.putInteger(SIZE, order.length);
                i = 0;
                while (i < order.length) {
                    orderMemento.putInteger(COLUMN + Integer.toString(i), order[i]);
                    ++i;
                }
            }
        }
    }

    public void resetColumnSizes(String[] columnIds) {
        int i = 0;
        while (i < columnIds.length) {
            this.fColumnSizes.remove(columnIds[i]);
            ++i;
        }
    }

    public void initState(IMemento memento) {
        int j;
        int length;
        Integer integer;
        String id;
        IMemento child;
        IMemento[] mementos = memento.getChildren(COLUMN_SIZES);
        int i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Integer size = child.getInteger(SIZE);
            if (size != null) {
                this.fColumnSizes.put(id, size);
            }
            ++i;
        }
        mementos = memento.getChildren(SHOW_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Boolean bool = Boolean.valueOf(child.getString(SHOW_COLUMNS));
            if (!bool.booleanValue()) {
                this.fShowColumns.put(id, bool);
            }
            ++i;
        }
        mementos = memento.getChildren(VISIBLE_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            integer = child.getInteger(SIZE);
            if (integer != null) {
                length = integer;
                String[] columns = new String[length];
                j = 0;
                while (j < length) {
                    columns[j] = child.getString(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fVisibleColumns.put(id, columns);
            }
            ++i;
        }
        mementos = memento.getChildren(COLUMN_ORDER);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            integer = child.getInteger(SIZE);
            if (integer != null) {
                length = integer;
                int[] order = new int[length];
                j = 0;
                while (j < length) {
                    order[j] = child.getInteger(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fColumnOrder.put(id, order);
            }
            ++i;
        }
    }

    private void initTreeViewerImpl() {
        this.fTreeEditorImpl = new TreeEditorImpl(this){

            Rectangle getBounds(Item item, int columnNumber) {
                return ((TreeItem)item).getBounds(columnNumber);
            }

            int getColumnCount() {
                return AsynchronousTreeViewer.this.getTree().getColumnCount();
            }

            Item[] getSelection() {
                return AsynchronousTreeViewer.this.getTree().getSelection();
            }

            void setEditor(Control w, Item item, int columnNumber) {
                AsynchronousTreeViewer.this.fTreeEditor.setEditor(w, (TreeItem)item, columnNumber);
            }

            void setSelection(IStructuredSelection selection, boolean b) {
                AsynchronousTreeViewer.this.setSelection((ISelection)selection, b);
            }

            void showSelection() {
                AsynchronousTreeViewer.this.getTree().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
                ((AsynchronousTreeViewer)AsynchronousTreeViewer.this).fTreeEditor.grabHorizontal = layoutData.grabHorizontal;
                ((AsynchronousTreeViewer)AsynchronousTreeViewer.this).fTreeEditor.horizontalAlignment = layoutData.horizontalAlignment;
                ((AsynchronousTreeViewer)AsynchronousTreeViewer.this).fTreeEditor.minimumWidth = layoutData.minimumWidth;
            }

            void handleDoubleClickEvent() {
                StructuredViewer viewer = this.getViewer();
                AsynchronousTreeViewer.this.fireDoubleClick(new DoubleClickEvent((Viewer)viewer, viewer.getSelection()));
                AsynchronousTreeViewer.this.fireOpen(new OpenEvent((Viewer)viewer, viewer.getSelection()));
            }
        };
    }

    public void editElement(Object element, int column) {
        this.fTreeEditorImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this.fTreeEditorImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.fTreeEditorImpl.getCellModifier();
    }

    public void cancelEditing() {
        this.fTreeEditorImpl.cancelEditing();
    }

    public boolean isCellEditorActive() {
        return this.fTreeEditorImpl.isCellEditorActive();
    }

    protected void setCellEditors(CellEditor[] editors) {
        this.fTreeEditorImpl.setCellEditors(editors);
    }

    protected void setCellModifier(ICellModifier modifier) {
        this.fTreeEditorImpl.setCellModifier(modifier);
    }

    protected void setColumnProperties(String[] columnProperties) {
        this.fTreeEditorImpl.setColumnProperties(columnProperties);
    }

    public void setShowColumns(boolean show) {
        if (show) {
            if (!this.isShowColumns()) {
                this.fShowColumns.remove(this.fColumnPresentation.getId());
            }
        } else if (this.isShowColumns()) {
            this.fShowColumns.put(this.fColumnPresentation.getId(), Boolean.FALSE);
        }
        this.refreshColumns();
    }

    public boolean isShowColumns() {
        if (this.fColumnPresentation != null) {
            return this.isShowColumns(this.fColumnPresentation.getId());
        }
        return false;
    }

    public boolean canToggleColumns() {
        return this.fColumnPresentation != null && this.fColumnPresentation.isOptional();
    }

    protected boolean isShowColumns(String columnPresentationId) {
        Boolean bool = (Boolean)this.fShowColumns.get(columnPresentationId);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    protected void nodeContainerChanged(ModelNode node) {
        Widget widget = this.findItem(node);
        if (widget != null && !widget.isDisposed()) {
            int childCount = node.getChildCount();
            this.setItemCount(widget, childCount);
            if (node.isContainer()) {
                if (widget instanceof TreeItem) {
                    if (((TreeItem)widget).getExpanded()) {
                        this.updateChildren(node);
                    }
                } else {
                    this.updateChildren(node);
                }
                this.attemptPendingUpdates();
            }
        }
    }

    protected void nodeChildrenChanged(ModelNode parentNode) {
        Widget widget = this.findItem(parentNode);
        if (widget != null && !widget.isDisposed()) {
            int childCount = parentNode.getChildCount();
            this.setItemCount(widget, childCount);
            TreeItem[] items = null;
            if (widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                if (treeItem.getExpanded()) {
                    items = treeItem.getItems();
                }
            } else {
                items = ((Tree)widget).getItems();
            }
            if (items != null) {
                int i = 0;
                while (i < items.length) {
                    if (items[i].getExpanded()) {
                        this.update((Item)items[i], i);
                    } else {
                        this.clearChild(widget, i);
                    }
                    ++i;
                }
            }
            this.attemptPendingUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List buildLabels(IProgressMonitor monitor, Object element, String taskName) {
        ModelNode[] theNodes = this.getModel().getNodes(element);
        ArrayList<LabelResult> results = new ArrayList<LabelResult>();
        if (theNodes != null && theNodes.length > 0) {
            ModelNode root = theNodes[0];
            ArrayList nodes = new ArrayList();
            this.collectNodes(nodes, root);
            monitor.beginTask(taskName, nodes.size());
            Iterator iterator = nodes.iterator();
            while (!monitor.isCanceled() && iterator.hasNext()) {
                ModelNode node = (ModelNode)iterator.next();
                IAsynchronousLabelAdapter labelAdapter = this.getModel().getLabelAdapter(node.getElement());
                if (labelAdapter != null) {
                    LabelResult result = new LabelResult(node, this.getModel());
                    labelAdapter.retrieveLabel(node.getElement(), this.getPresentationContext(), result);
                    LabelResult labelResult = result;
                    synchronized (labelResult) {
                        if (!result.isDone()) {
                            try {
                                result.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                monitor.setCanceled(true);
                                return null;
                            }
                        }
                    }
                    IStatus status = result.getStatus();
                    if (status == null || status.isOK()) {
                        results.add(result);
                    }
                }
                monitor.worked(1);
            }
        }
        monitor.done();
        return results;
    }

    private void collectNodes(List nodes, ModelNode node) {
        ModelNode[] childrenNodes;
        if (node.getParentNode() != null) {
            nodes.add(node);
        }
        if ((childrenNodes = node.getChildrenNodes()) != null) {
            int i = 0;
            while (i < childrenNodes.length) {
                this.collectNodes(nodes, childrenNodes[i]);
                ++i;
            }
        }
    }

    protected int indexOf(Widget parent, Widget child) {
        if (parent instanceof Tree) {
            return ((Tree)parent).indexOf((TreeItem)child);
        }
        return ((TreeItem)parent).indexOf((TreeItem)child);
    }

    protected boolean selectionExists(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)selection;
            TreePath[] paths = ts.getPaths();
            int matchingPaths = 0;
            int i = 0;
            while (i < paths.length) {
                TreePath path = paths[i];
                Object element = path.getLastSegment();
                ModelNode[] nodes = this.getModel().getNodes(element);
                if (nodes != null) {
                    int j = 0;
                    while (j < nodes.length) {
                        ModelNode node = nodes[j];
                        if (node.getTreePath().equals((Object)path)) {
                            ++matchingPaths;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return matchingPaths == paths.length;
        }
        return super.selectionExists(selection);
    }

    class ColumnListener
    implements ControlListener {
        ColumnListener() {
        }

        public void controlMoved(ControlEvent e) {
            AsynchronousTreeViewer.this.persistColumnOrder();
        }

        public void controlResized(ControlEvent e) {
            AsynchronousTreeViewer.this.persistColumnSizes();
        }
    }
}

