/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class LaunchShortcutsAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private Menu fCreatedMenu;
    private ILaunchGroup fGroup;
    private boolean fInitialized = false;

    public LaunchShortcutsAction(String launchGroupIdentifier) {
        this.fGroup = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(launchGroupIdentifier);
        ILaunchMode mode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.fGroup.getMode());
        this.setText(mode.getLaunchAsLabel());
        this.setMenuCreator(this);
        this.setEnabled(this.existsConfigTypesForMode());
    }

    private ILaunchGroup getLaunchGroup() {
        return this.fGroup;
    }

    public void run() {
    }

    public void dispose() {
        if (this.getCreatedMenu() != null) {
            this.getCreatedMenu().dispose();
        }
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        if (this.getCreatedMenu() != null) {
            this.getCreatedMenu().dispose();
        }
        this.setCreatedMenu(new Menu(parent));
        this.initMenu();
        return this.getCreatedMenu();
    }

    private IEvaluationContext createContext() {
        IWorkbenchPage page;
        List<Object> list = null;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ISelection selection;
            ISelectionProvider selectionProvider;
            IWorkbenchPartSite site;
            IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof IEditorPart) {
                list = new ArrayList<IEditorInput>();
                list.add(((IEditorPart)activePart).getEditorInput());
            } else if (activePart != null && (site = activePart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
                list = ((IStructuredSelection)selection).toList();
            }
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        EvaluationContext context = new EvaluationContext(null, (Object)list);
        context.addVariable("selection", (Object)list);
        return context;
    }

    private void fillMenu() {
        IEvaluationContext context = this.createContext();
        List allShortCuts = this.getLaunchConfigurationManager().getLaunchShortcuts(this.getLaunchGroup().getCategory());
        Iterator iter = allShortCuts.iterator();
        ArrayList<LaunchShortcutExtension> filteredShortCuts = new ArrayList<LaunchShortcutExtension>(10);
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = (LaunchShortcutExtension)iter.next();
            try {
                if (WorkbenchActivityHelper.filterItem((Object)ext) || !this.isApplicable(ext, context)) continue;
                filteredShortCuts.add(ext);
            }
            catch (CoreException coreException) {}
        }
        iter = filteredShortCuts.iterator();
        int accelerator = 1;
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = (LaunchShortcutExtension)iter.next();
            Set modes = ext.getModes();
            for (String mode : modes) {
                if (!mode.equals(this.getMode())) continue;
                this.populateMenuItem(mode, ext, this.fCreatedMenu, accelerator++);
            }
        }
        if (accelerator == 1) {
            Action action = new Action(ActionMessages.LaunchShortcutsAction_1){};
            action.setEnabled(false);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.fCreatedMenu, -1);
        }
    }

    private void populateMenuItem(String mode, LaunchShortcutExtension ext, Menu menu, int accelerator) {
        String contextLabel;
        LaunchShortcutAction action = new LaunchShortcutAction(mode, ext);
        action.setActionDefinitionId(String.valueOf(ext.getId()) + "." + mode);
        String helpContextId = ext.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, helpContextId);
        }
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append((contextLabel = ext.getContextLabel(mode)) != null ? contextLabel : action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }

    private boolean isApplicable(LaunchShortcutExtension ext, IEvaluationContext context) throws CoreException {
        Expression expr = ext.getContextualLaunchEnablementExpression();
        return ext.evalEnablementExpression(context, expr);
    }

    private void initMenu() {
        this.fCreatedMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                LaunchShortcutsAction.this.fillMenu();
            }
        });
    }

    private String getMode() {
        return this.getLaunchGroup().getMode();
    }

    private Menu getCreatedMenu() {
        return this.fCreatedMenu;
    }

    private void setCreatedMenu(Menu createdMenu) {
        this.fCreatedMenu = createdMenu;
    }

    private LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!this.fInitialized) {
            action.setEnabled(this.existsConfigTypesForMode());
            this.fInitialized = true;
        }
    }

    private boolean existsConfigTypesForMode() {
        ILaunchConfigurationType[] configTypes = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        int i = 0;
        while (i < configTypes.length) {
            ILaunchConfigurationType configType = configTypes[i];
            if (configType.supportsMode(this.getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

