/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.apache.naming.ContextAccessController;
import org.apache.naming.NameParserImpl;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.StringManager;

public class NamingContext
implements Context {
    protected static final NameParser nameParser = new NameParserImpl();
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager("org.apache.naming");
    protected Hashtable bindings = new Hashtable();
    protected String name;

    public NamingContext(Hashtable env, String name) throws NamingException {
        this.env = new Hashtable();
        this.name = name;
        if (env != null) {
            Enumeration envEntries = env.keys();
            while (envEntries.hasMoreElements()) {
                String entryName = (String)envEntries.nextElement();
                this.addToEnvironment(entryName, env.get(entryName));
            }
        }
    }

    public NamingContext(Hashtable env, String name, Hashtable bindings) throws NamingException {
        this(env, name);
        this.bindings = bindings;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name, true);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name), true);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name, obj, false);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.bind(name, obj, true);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unbind(Name name) throws NamingException {
        this.checkWritable();
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(this.sm.getString("namingContext.invalidName"));
        }
        NamingEntry entry = (NamingEntry)this.bindings.get(name.get(0));
        if (entry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (name.size() > 1) {
            if (entry.type != 10) throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            ((Context)entry.value).unbind(name.getSuffix(1));
            return;
        } else {
            this.bindings.remove(name.get(0));
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        Object value = this.lookup(oldName);
        this.bind(newName, value);
        this.unbind(oldName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContextEnumeration(this.bindings.elements());
        }
        NamingEntry entry = (NamingEntry)this.bindings.get(name.get(0));
        if (entry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (entry.type != 10) {
            throw new NamingException(this.sm.getString("namingContext.contextExpected"));
        }
        return ((Context)entry.value).list(name.getSuffix(1));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContextBindingsEnumeration(this.bindings.elements());
        }
        NamingEntry entry = (NamingEntry)this.bindings.get(name.get(0));
        if (entry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (entry.type != 10) {
            throw new NamingException(this.sm.getString("namingContext.contextExpected"));
        }
        return ((Context)entry.value).listBindings(name.getSuffix(1));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroySubcontext(Name name) throws NamingException {
        this.checkWritable();
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(this.sm.getString("namingContext.invalidName"));
        }
        NamingEntry entry = (NamingEntry)this.bindings.get(name.get(0));
        if (entry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (name.size() > 1) {
            if (entry.type != 10) throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            ((Context)entry.value).unbind(name.getSuffix(1));
            return;
        } else {
            if (entry.type != 10) throw new NotContextException(this.sm.getString("namingContext.contextExpected"));
            ((Context)entry.value).close();
            this.bindings.remove(name.get(0));
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        this.checkWritable();
        NamingContext newContext = new NamingContext(this.env, this.name);
        this.bind(name, (Object)newContext);
        return newContext;
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name, false);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(new CompositeName(name), false);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return nameParser;
        }
        if (name.size() > 1) {
            Object obj = this.bindings.get(name.get(0));
            if (obj instanceof Context) {
                return ((Context)obj).getNameParser(name.getSuffix(1));
            }
            throw new NotContextException(this.sm.getString("namingContext.contextExpected"));
        }
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        prefix = (Name)name.clone();
        return prefix.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return prefix + "/" + name;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env.clear();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException(this.sm.getString("namingContext.noAbsoluteName"));
    }

    protected Object lookup(Name name, boolean resolveLinks) throws NamingException {
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            return new NamingContext(this.env, this.name, this.bindings);
        }
        NamingEntry entry = (NamingEntry)this.bindings.get(name.get(0));
        if (entry == null) {
            throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
        }
        if (name.size() > 1) {
            if (entry.type != 10) {
                throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            }
            return ((Context)entry.value).lookup(name.getSuffix(1));
        }
        if (resolveLinks && entry.type == 1) {
            String link = ((LinkRef)entry.value).getLinkName();
            if (link.startsWith(".")) {
                return this.lookup(link.substring(1));
            }
            return new InitialContext(this.env).lookup(link);
        }
        if (entry.type == 2) {
            try {
                Object obj = NamingManager.getObjectInstance(entry.value, name, this, this.env);
                if (obj != null) {
                    entry.value = obj;
                    entry.type = 0;
                }
                return obj;
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NamingException(e.getMessage());
            }
        }
        return entry.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bind(Name name, Object obj, boolean rebind) throws NamingException {
        this.checkWritable();
        while (!name.isEmpty() && name.get(0).length() == 0) {
            name = name.getSuffix(1);
        }
        if (name.isEmpty()) {
            throw new NamingException(this.sm.getString("namingContext.invalidName"));
        }
        NamingEntry entry = (NamingEntry)this.bindings.get(name.get(0));
        if (name.size() > 1) {
            if (entry == null) {
                throw new NameNotFoundException(this.sm.getString("namingContext.nameNotBound", name.get(0)));
            }
            if (entry.type != 10) throw new NamingException(this.sm.getString("namingContext.contextExpected"));
            if (rebind) {
                ((Context)entry.value).rebind(name.getSuffix(1), obj);
                return;
            } else {
                ((Context)entry.value).bind(name.getSuffix(1), obj);
            }
            return;
        } else {
            if (!rebind && entry != null) {
                throw new NamingException(this.sm.getString("namingContext.alreadyBound", name.get(0)));
            }
            Object toBind = NamingManager.getStateToBind(obj, name, this, this.env);
            if (toBind instanceof Context) {
                entry = new NamingEntry(name.get(0), toBind, 10);
            } else if (toBind instanceof LinkRef) {
                entry = new NamingEntry(name.get(0), toBind, 1);
            } else if (toBind instanceof Reference) {
                entry = new NamingEntry(name.get(0), toBind, 2);
            } else if (toBind instanceof Referenceable) {
                toBind = ((Referenceable)toBind).getReference();
                entry = new NamingEntry(name.get(0), toBind, 2);
            } else {
                entry = new NamingEntry(name.get(0), toBind, 0);
            }
            this.bindings.put(name.get(0), entry);
        }
    }

    protected boolean isWritable() {
        return ContextAccessController.isWritable(this.name);
    }

    protected void checkWritable() throws NamingException {
        if (!this.isWritable()) {
            throw new NamingException(this.sm.getString("namingContext.readOnly"));
        }
    }
}

