/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.GIOP;

import gnu.CORBA.CDR.AbstractCdrInput;
import gnu.CORBA.CDR.AbstractCdrOutput;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.IDLEntity;

public class ServiceContext
implements IDLEntity {
    private static final long serialVersionUID = 1L;
    public static final int TransactionService = 0;
    public static final int CodeSets = 1;
    public static final int ChainBypassCheck = 2;
    public static final int ChainBypassInfo = 3;
    public static final int LogicalThreadId = 4;
    public static final int BI_DIR_IIOP = 5;
    public static final int SendingContextRunTime = 6;
    public static final int INVOCATION_POLICIES = 7;
    public static final int FORWARDED_IDENTITY = 8;
    public static final int UnknownExceptionInfo = 9;
    public static final int RTCorbaPriority = 10;
    public static final int RTCorbaPriorityRange = 11;
    public static final int FT_GROUP_VERSION = 12;
    public static final int FT_REQUEST = 13;
    public static final int ExceptionDetailMessage = 14;
    public static final int SecurityAttributeService = 15;
    public static final int ActivityService = 16;
    public int context_id;
    public byte[] context_data;

    public ServiceContext() {
    }

    public ServiceContext(org.omg.IOP.ServiceContext serviceContext) {
        this.context_id = serviceContext.context_id;
        this.context_data = serviceContext.context_data;
    }

    public static ServiceContext read(AbstractCdrInput abstractCdrInput) {
        int n = abstractCdrInput.read_ulong();
        if (n == 1) {
            CodeSetServiceContext codeSetServiceContext = new CodeSetServiceContext();
            codeSetServiceContext.readContext(abstractCdrInput);
            return codeSetServiceContext;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.context_id = n;
        serviceContext.context_data = abstractCdrInput.read_sequence();
        return serviceContext;
    }

    public static ServiceContext[] readSequence(AbstractCdrInput abstractCdrInput) {
        int n = abstractCdrInput.read_long();
        ServiceContext[] serviceContextArray = new ServiceContext[n];
        for (int i = 0; i < serviceContextArray.length; ++i) {
            serviceContextArray[i] = ServiceContext.read(abstractCdrInput);
        }
        return serviceContextArray;
    }

    public void write(AbstractCdrOutput abstractCdrOutput) {
        abstractCdrOutput.write_ulong(this.context_id);
        abstractCdrOutput.write_sequence(this.context_data);
    }

    public static void writeSequence(AbstractCdrOutput abstractCdrOutput, ServiceContext[] serviceContextArray) {
        abstractCdrOutput.write_long(serviceContextArray.length);
        for (int i = 0; i < serviceContextArray.length; ++i) {
            serviceContextArray[i].write(abstractCdrOutput);
        }
    }

    public static void add(org.omg.IOP.ServiceContext[] serviceContextArray, org.omg.IOP.ServiceContext serviceContext, boolean bl) {
        int n = -1;
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != serviceContext.context_id) continue;
            n = i;
        }
        if (n < 0) {
            org.omg.IOP.ServiceContext[] serviceContextArray2 = new org.omg.IOP.ServiceContext[serviceContextArray.length + 1];
            for (int i = 0; i < serviceContextArray.length; ++i) {
                serviceContextArray2[i] = serviceContextArray[i];
            }
            serviceContextArray2[serviceContextArray.length] = serviceContext;
        } else {
            if (!bl) {
                throw new BAD_INV_ORDER("Repetetive setting of the context " + serviceContext.context_id, 15, CompletionStatus.COMPLETED_NO);
            }
            serviceContextArray[n] = serviceContext;
        }
    }

    public static ServiceContext[] add(ServiceContext[] serviceContextArray, org.omg.IOP.ServiceContext serviceContext, boolean bl) {
        int n = -1;
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != serviceContext.context_id) continue;
            n = i;
        }
        if (n < 0) {
            ServiceContext[] serviceContextArray2 = new ServiceContext[serviceContextArray.length + 1];
            for (int i = 0; i < serviceContextArray.length; ++i) {
                serviceContextArray2[i] = serviceContextArray[i];
            }
            serviceContextArray2[serviceContextArray.length] = new ServiceContext(serviceContext);
            return serviceContextArray2;
        }
        if (!bl) {
            throw new BAD_INV_ORDER("Repetetive setting of the context " + serviceContext.context_id, 15, CompletionStatus.COMPLETED_NO);
        }
        serviceContextArray[n] = new ServiceContext(serviceContext);
        return serviceContextArray;
    }

    public static org.omg.IOP.ServiceContext findContext(int n, org.omg.IOP.ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != n) continue;
            return serviceContextArray[i];
        }
        throw new BAD_PARAM("No context with id " + n);
    }

    public static org.omg.IOP.ServiceContext findContext(int n, ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != n) continue;
            return new org.omg.IOP.ServiceContext(n, serviceContextArray[i].context_data);
        }
        throw new BAD_PARAM("No context with id " + n);
    }

    public static ServiceContext find(int n, ServiceContext[] serviceContextArray) {
        for (int i = 0; i < serviceContextArray.length; ++i) {
            if (serviceContextArray[i].context_id != n) continue;
            return serviceContextArray[i];
        }
        return null;
    }

    public String toString() {
        return "ctx " + this.context_id + ", size " + this.context_data.length;
    }
}

