/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.event.filters;

import gnu.classpath.jdwp.event.Event;
import gnu.classpath.jdwp.event.filters.IEventFilter;
import gnu.classpath.jdwp.exception.InvalidStringException;

public class ClassMatchFilter
implements IEventFilter {
    private String _pattern;

    public ClassMatchFilter(String string) throws InvalidStringException {
        int n = string.indexOf(42);
        if (n != -1 && n != 0 && n != string.length() - 1) {
            throw new InvalidStringException("pattern may be an exact match or start/end with \"*\"");
        }
        this._pattern = string;
    }

    public String getPattern() {
        return this._pattern;
    }

    public boolean matches(Event event) {
        Object object = event.getParameter(1);
        if (object != null) {
            Class clazz = (Class)object;
            String string = clazz.getName();
            if (this._pattern.startsWith("*")) {
                return string.endsWith(this._pattern.substring(1));
            }
            if (this._pattern.endsWith("*")) {
                int n = this._pattern.length() - 1;
                return string.startsWith(this._pattern.substring(0, n));
            }
            return string.matches(this._pattern);
        }
        return false;
    }
}

