/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.ComponentGraphicsCopy;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;

public class ComponentGraphics
extends CairoGraphics2D {
    private static final boolean hasXRenderExtension = ComponentGraphics.hasXRender();
    private GtkComponentPeer component;
    protected long cairo_t;
    private static ThreadLocal hasLock = new ThreadLocal();
    private static Integer ONE = 1;

    private void lock() {
        Integer n = (Integer)hasLock.get();
        if (n == null) {
            this.start_gdk_drawing();
            hasLock.set(ONE);
        } else {
            hasLock.set(n + 1);
        }
    }

    private void unlock() {
        Integer n = (Integer)hasLock.get();
        if (n == null) {
            throw new IllegalStateException();
        }
        if (n == ONE) {
            hasLock.set(null);
            this.end_gdk_drawing();
        } else {
            hasLock.set(n - 1);
        }
    }

    ComponentGraphics() {
    }

    private ComponentGraphics(GtkComponentPeer gtkComponentPeer) {
        this.component = gtkComponentPeer;
        this.cairo_t = this.initState(gtkComponentPeer);
        this.setup(this.cairo_t);
        Rectangle rectangle = gtkComponentPeer.awtComponent.getBounds();
        this.setClip(new Rectangle(0, 0, rectangle.width, rectangle.height));
        this.setBackground(gtkComponentPeer.awtComponent.getBackground());
        this.setColor(gtkComponentPeer.awtComponent.getForeground());
    }

    private ComponentGraphics(ComponentGraphics componentGraphics) {
        this.component = componentGraphics.component;
        this.cairo_t = this.initState(this.component);
        this.copy(componentGraphics, this.cairo_t);
        Rectangle rectangle = this.component.awtComponent.getBounds();
        this.setClip(new Rectangle(0, 0, rectangle.width, rectangle.height));
        this.setBackground(this.component.awtComponent.getBackground());
        this.setColor(this.component.awtComponent.getForeground());
    }

    private native long initState(GtkComponentPeer var1);

    public void dispose() {
        super.dispose();
        this.disposeSurface(this.nativePointer);
    }

    private native void disposeSurface(long var1);

    protected native long initFromVolatile(long var1, int var3, int var4);

    private native void start_gdk_drawing();

    private native void end_gdk_drawing();

    public static native boolean hasXRender();

    private static native Pointer nativeGrab(GtkComponentPeer var0);

    private native void copyAreaNative(GtkComponentPeer var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void drawVolatile(GtkComponentPeer var1, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public static GtkImage grab(GtkComponentPeer gtkComponentPeer) {
        return new GtkImage(ComponentGraphics.nativeGrab(gtkComponentPeer));
    }

    public static Graphics2D getComponentGraphics(GtkComponentPeer gtkComponentPeer) {
        if (hasXRenderExtension) {
            return new ComponentGraphics(gtkComponentPeer);
        }
        Rectangle rectangle = gtkComponentPeer.awtComponent.getBounds();
        return new ComponentGraphicsCopy(rectangle.width, rectangle.height, gtkComponentPeer);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.component.getGraphicsConfiguration();
    }

    public Graphics create() {
        return new ComponentGraphics(this);
    }

    protected Rectangle2D getRealBounds() {
        return this.component.awtComponent.getBounds();
    }

    public void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyAreaNative(this.component, n, n2, n3, n4, n5, n6);
    }

    public void draw(Shape shape) {
        this.lock();
        try {
            super.draw(shape);
        }
        finally {
            Object var2_2 = null;
            this.unlock();
        }
    }

    public void fill(Shape shape) {
        this.lock();
        try {
            super.fill(shape);
        }
        finally {
            Object var2_2 = null;
            this.unlock();
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.lock();
        try {
            super.drawRenderedImage(renderedImage, affineTransform);
        }
        finally {
            Object var3_3 = null;
            this.unlock();
        }
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        boolean bl;
        this.lock();
        try {
            bl = super.drawImage(image, affineTransform, color, imageObserver);
        }
        finally {
            Object var6_6 = null;
            this.unlock();
        }
        boolean bl2 = bl;
        return bl2;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.lock();
        try {
            super.drawGlyphVector(glyphVector, f, f2);
        }
        finally {
            Object var4_4 = null;
            this.unlock();
        }
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        if (image instanceof GtkVolatileImage) {
            GtkVolatileImage gtkVolatileImage = (GtkVolatileImage)image;
            int n3 = this.transform.getType();
            if (!(n3 != 0 && n3 != 1 || this.clip != null && !(this.clip instanceof Rectangle2D))) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                if (rectangle2D == null) {
                    rectangle2D = this.getRealBounds();
                }
                n = (int)((double)n + this.transform.getTranslateX());
                n2 = (int)((double)n2 + this.transform.getTranslateY());
                this.drawVolatile(this.component, gtkVolatileImage.nativePointer, n, n2, gtkVolatileImage.width, gtkVolatileImage.height, (int)(rectangle2D.getX() + this.transform.getTranslateX()), (int)(rectangle2D.getY() + this.transform.getTranslateY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                return true;
            }
            return super.drawImage((Image)gtkVolatileImage.getSnapshot(), n, n2, imageObserver);
        }
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            ImageProducer imageProducer = image.getSource();
            if (imageProducer == null) {
                return false;
            }
            bufferedImage = (BufferedImage)Toolkit.getDefaultToolkit().createImage(imageProducer);
        }
        return super.drawImage((Image)bufferedImage, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        if (image instanceof GtkVolatileImage && (this.clip == null || this.clip instanceof Rectangle2D)) {
            GtkVolatileImage gtkVolatileImage = (GtkVolatileImage)image;
            int n5 = this.transform.getType();
            if (!(n5 != 0 && n5 != 1 || this.clip != null && !(this.clip instanceof Rectangle2D))) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                if (rectangle2D == null) {
                    rectangle2D = this.getRealBounds();
                }
                n = (int)((double)n + this.transform.getTranslateX());
                n2 = (int)((double)n2 + this.transform.getTranslateY());
                this.drawVolatile(this.component, gtkVolatileImage.nativePointer, n, n2, n3, n4, (int)(rectangle2D.getX() + this.transform.getTranslateX()), (int)(rectangle2D.getY() + this.transform.getTranslateY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                return true;
            }
            return super.drawImage(gtkVolatileImage.getSnapshot(), n, n2, n3, n4, imageObserver);
        }
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            ImageProducer imageProducer = image.getSource();
            if (imageProducer == null) {
                return false;
            }
            bufferedImage = (BufferedImage)Toolkit.getDefaultToolkit().createImage(imageProducer);
        }
        return super.drawImage(bufferedImage, n, n2, n3, n4, imageObserver);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.lock();
        try {
            super.drawLine(n, n2, n3, n4);
        }
        finally {
            Object var5_5 = null;
            this.unlock();
        }
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.lock();
        try {
            super.drawRect(n, n2, n3, n4);
        }
        finally {
            Object var5_5 = null;
            this.unlock();
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.lock();
        try {
            super.fillRect(n, n2, n3, n4);
        }
        finally {
            Object var5_5 = null;
            this.unlock();
        }
    }

    public void setClip(Shape shape) {
        this.lock();
        try {
            super.setClip(shape);
        }
        finally {
            Object var2_2 = null;
            this.unlock();
        }
    }
}

