/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkClipboardNotifier;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkSelection;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;

public class GtkClipboard
extends Clipboard {
    static final GtkClipboard clipboard = new GtkClipboard("System Clipboard");
    static final GtkClipboard selection = new GtkClipboard("System Selection");
    static final String stringMimeType = DataFlavor.stringFlavor.getMimeType();
    static final String imageMimeType = DataFlavor.imageFlavor.getMimeType();
    static final String filesMimeType = DataFlavor.javaFileListFlavor.getMimeType();
    static final boolean canCache = GtkClipboard.initNativeState(clipboard, selection, stringMimeType, imageMimeType, filesMimeType);

    private GtkClipboard(String string) {
        super(string);
        this.setContents(new GtkSelection(this), null);
    }

    static GtkClipboard getClipboardInstance() {
        return clipboard;
    }

    static GtkClipboard getSelectionInstance() {
        return selection;
    }

    private synchronized void setSystemContents(boolean bl) {
        boolean bl2;
        boolean bl3 = this.contents instanceof GtkSelection ^ true;
        boolean bl4 = bl2 = bl && bl3 || !bl && !bl3;
        if (bl2) {
            GtkClipboardNotifier.announce(this);
        }
    }

    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        super.setContents(transferable, clipboardOwner);
        if (transferable == null) {
            this.advertiseContent(null, false, false, false);
            return;
        }
        if (transferable instanceof GtkSelection) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (transferable instanceof StringSelection || transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(DataFlavor.plainTextFlavor) || transferable.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor())) {
            bl = true;
        }
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        String[] stringArray = new String[dataFlavorArray.length];
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            String string;
            DataFlavor dataFlavor = dataFlavorArray[i];
            stringArray[i] = string = dataFlavor.getMimeType();
            if (!bl && ("text".equals(dataFlavor.getPrimaryType()) || dataFlavor.isRepresentationClassReader())) {
                bl = true;
            }
            if (!bl2 && dataFlavorArray[i].equals(DataFlavor.imageFlavor)) {
                try {
                    Object object = transferable.getTransferData(DataFlavor.imageFlavor);
                    if (object instanceof Image) {
                        bl2 = true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (!dataFlavorArray[i].equals(DataFlavor.javaFileListFlavor)) continue;
            bl3 = true;
        }
        this.advertiseContent(stringArray, bl, bl2, bl3);
    }

    private native void advertiseContent(String[] var1, boolean var2, boolean var3, boolean var4);

    private String provideText() {
        Transferable transferable = this.contents;
        if (transferable == null || transferable instanceof GtkSelection) {
            return null;
        }
        if (transferable instanceof StringSelection) {
            try {
                return (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        try {
            DataFlavor dataFlavor = DataFlavor.getTextPlainUnicodeFlavor();
            Reader reader = dataFlavor.getReaderForText(transferable);
            if (reader != null) {
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[1024];
                int n = reader.read(cArray);
                while (n != -1) {
                    stringBuffer.append(cArray, 0, n);
                    n = reader.read(cArray);
                }
                return stringBuffer.toString();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private GtkImage provideImage() {
        Transferable transferable = this.contents;
        if (transferable == null || transferable instanceof GtkSelection) {
            return null;
        }
        try {
            Object object = transferable.getTransferData(DataFlavor.imageFlavor);
            if (object instanceof GtkImage) {
                return (GtkImage)object;
            }
            return new GtkImage(((Image)object).getSource());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private String[] provideURIs() {
        Transferable transferable = this.contents;
        if (transferable == null || transferable instanceof GtkSelection) {
            return null;
        }
        try {
            List list2 = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            String[] stringArray = new String[list2.size()];
            int n = 0;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = ((File)iterator.next()).toURI().toString();
            }
            return stringArray;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private byte[] provideContent(String string) {
        Transferable transferable = this.contents;
        if (transferable == null || transferable instanceof GtkSelection) {
            return null;
        }
        try {
            DataFlavor dataFlavor = new DataFlavor(string);
            Object object = transferable.getTransferData(dataFlavor);
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                return byteArrayOutputStream.toByteArray();
            }
            if (object instanceof Serializable) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                return byteArrayOutputStream.toByteArray();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    private static native boolean initNativeState(GtkClipboard var0, GtkClipboard var1, String var2, String var3, String var4);
}

