/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.ComponentGraphics;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;

public class VolatileImageGraphics
extends ComponentGraphics {
    private GtkVolatileImage owner;

    public VolatileImageGraphics(GtkVolatileImage gtkVolatileImage) {
        this.owner = gtkVolatileImage;
        this.cairo_t = this.initFromVolatile(this.owner.nativePointer, gtkVolatileImage.width, gtkVolatileImage.height);
        this.setup(this.cairo_t);
    }

    private VolatileImageGraphics(VolatileImageGraphics volatileImageGraphics) {
        this.owner = volatileImageGraphics.owner;
        this.cairo_t = this.initFromVolatile(this.owner.nativePointer, this.owner.width, this.owner.height);
        this.copy(volatileImageGraphics, this.cairo_t);
    }

    public void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        this.owner.copyArea(n, n2, n3, n4, n5, n6);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.owner.component.getGraphicsConfiguration();
    }

    public Graphics create() {
        return new VolatileImageGraphics(this);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof GtkVolatileImage) {
            this.owner.drawVolatile(((GtkVolatileImage)image).nativePointer, n, n2, ((GtkVolatileImage)image).width, ((GtkVolatileImage)image).height);
            return true;
        }
        return super.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (image instanceof GtkVolatileImage) {
            this.owner.drawVolatile(((GtkVolatileImage)image).nativePointer, n, n2, n3, n4);
            return true;
        }
        return super.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.owner.width, this.owner.height);
    }
}

