/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.GenericSignatureParser;
import gnu.java.lang.reflect.TypeImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

public class MethodSignatureParser
extends GenericSignatureParser {
    private TypeVariable[] typeParameters = this.peekChar() == '<' ? this.readFormalTypeParameters() : new TypeVariable[0];
    private Type[] argTypes;
    private Type retType;
    private Type[] throwsSigs;

    public MethodSignatureParser(Method method, String string) {
        this(method, method.getDeclaringClass().getClassLoader(), string);
    }

    public MethodSignatureParser(Constructor constructor, String string) {
        this(constructor, constructor.getDeclaringClass().getClassLoader(), string);
    }

    private MethodSignatureParser(GenericDeclaration genericDeclaration, ClassLoader classLoader, String string) {
        super(genericDeclaration, classLoader, string);
        this.consume('(');
        ArrayList arrayList = new ArrayList();
        while (this.peekChar() != ')') {
            arrayList.add(this.readTypeSignature());
        }
        this.argTypes = new Type[arrayList.size()];
        arrayList.toArray(this.argTypes);
        this.consume(')');
        this.retType = this.readTypeSignature();
        ArrayList arrayList2 = new ArrayList();
        while (this.peekChar() == '^') {
            this.consume('^');
            if (this.peekChar() == 'T') {
                arrayList2.add(this.readTypeVariableSignature());
                continue;
            }
            arrayList2.add(this.readClassTypeSignature());
        }
        this.throwsSigs = new Type[arrayList2.size()];
        arrayList2.toArray(this.throwsSigs);
        this.end();
    }

    public TypeVariable[] getTypeParameters() {
        TypeImpl.resolve(this.typeParameters);
        return this.typeParameters;
    }

    public Type[] getGenericParameterTypes() {
        TypeImpl.resolve(this.argTypes);
        return this.argTypes;
    }

    public Type getGenericReturnType() {
        this.retType = TypeImpl.resolve(this.retType);
        return this.retType;
    }

    public Type[] getGenericExceptionTypes() {
        TypeImpl.resolve(this.throwsSigs);
        return this.throwsSigs;
    }

    private Type readTypeSignature() {
        switch (this.peekChar()) {
            case 'T': {
                return this.readTypeVariableSignature();
            }
            case 'L': {
                return this.readClassTypeSignature();
            }
            case '[': {
                return this.readArrayTypeSignature();
            }
            case 'Z': {
                this.consume('Z');
                return Boolean.TYPE;
            }
            case 'B': {
                this.consume('B');
                return Byte.TYPE;
            }
            case 'S': {
                this.consume('S');
                return Short.TYPE;
            }
            case 'C': {
                this.consume('C');
                return Character.TYPE;
            }
            case 'I': {
                this.consume('I');
                return Integer.TYPE;
            }
            case 'F': {
                this.consume('F');
                return Float.TYPE;
            }
            case 'J': {
                this.consume('J');
                return Long.TYPE;
            }
            case 'D': {
                this.consume('D');
                return Double.TYPE;
            }
            case 'V': {
                this.consume('V');
                return Void.TYPE;
            }
        }
        throw new GenericSignatureFormatError();
    }
}

