/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.gcjlib;

import gnu.gcj.Core;
import gnu.gcj.runtime.SharedLibHelper;
import gnu.java.net.protocol.core.CoreInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

class Connection
extends URLConnection {
    String solib;
    String name;
    Core core;

    public Connection(URL uRL) throws MalformedURLException {
        super(uRL);
        int n = uRL.getFile().indexOf("!/");
        if (n == -1) {
            throw new MalformedURLException("couldn't find !/ in gcjlib URL");
        }
        this.name = uRL.getFile().substring(n + 2);
        this.solib = uRL.getFile().substring(0, n);
    }

    public void connect() throws IOException {
        if (this.core != null) {
            return;
        }
        SharedLibHelper sharedLibHelper = SharedLibHelper.findHelper(this.solib);
        if (sharedLibHelper == null) {
            throw new IOException("library not loaded: " + this.solib);
        }
        this.core = sharedLibHelper.findCore(this.name);
        if (this.core == null) {
            throw new IOException("couldn't find core object: " + this.name);
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return new CoreInputStream(this.core);
    }

    public String getHeaderField(String string) {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (string.equals("content-type")) {
                return URLConnection.guessContentTypeFromName(this.name);
            }
            if (string.equals("content-length")) {
                return Long.toString(this.core.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

