/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.der;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DER;
import gnu.java.security.der.DEREncodingException;
import gnu.java.security.der.DERValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;

public class DERWriter
implements DER {
    private DERWriter() {
    }

    public static int write(OutputStream outputStream, DERValue dERValue) throws IOException {
        if (DER.CONSTRUCTED_VALUE.equals(dERValue.getValue())) {
            outputStream.write(dERValue.getEncoded());
            return dERValue.getLength();
        }
        outputStream.write(dERValue.getExternalTag());
        Object object = dERValue.getValue();
        if (object == null) {
            DERWriter.writeLength(outputStream, 0);
            return 0;
        }
        if (object instanceof Boolean) {
            return DERWriter.writeBoolean(outputStream, (Boolean)object);
        }
        if (object instanceof BigInteger) {
            return DERWriter.writeInteger(outputStream, (BigInteger)object);
        }
        if (object instanceof Date) {
            return DERWriter.writeDate(outputStream, dERValue.getExternalTag(), (Date)object);
        }
        if (object instanceof String) {
            return DERWriter.writeString(outputStream, dERValue.getExternalTag(), (String)object);
        }
        if (object instanceof List) {
            return DERWriter.writeSequence(outputStream, (List)object);
        }
        if (object instanceof Set) {
            return DERWriter.writeSet(outputStream, (Set)object);
        }
        if (object instanceof BitString) {
            return DERWriter.writeBitString(outputStream, (BitString)object);
        }
        if (object instanceof OID) {
            return DERWriter.writeOID(outputStream, (OID)object);
        }
        if (object instanceof byte[]) {
            DERWriter.writeLength(outputStream, ((byte[])object).length);
            outputStream.write((byte[])object);
            return ((byte[])object).length;
        }
        if (object instanceof DERValue) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DERWriter.write(byteArrayOutputStream, (DERValue)object);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            DERWriter.writeLength(outputStream, byArray.length);
            outputStream.write(byArray);
            return byArray.length;
        }
        throw new DEREncodingException("cannot encode " + object.getClass().getName());
    }

    public static int definiteEncodingSize(int n) {
        if (n < 128) {
            return 1;
        }
        if (n < 256) {
            return 2;
        }
        if (n < 65536) {
            return 3;
        }
        if (n < 0x1000000) {
            return 4;
        }
        return 5;
    }

    private static int writeBoolean(OutputStream outputStream, Boolean bl) throws IOException {
        DERWriter.writeLength(outputStream, 1);
        if (bl.booleanValue()) {
            outputStream.write(255);
        } else {
            outputStream.write(0);
        }
        return 1;
    }

    private static int writeInteger(OutputStream outputStream, BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        DERWriter.writeLength(outputStream, byArray.length);
        outputStream.write(byArray);
        return byArray.length;
    }

    private static int writeSequence(OutputStream outputStream, List list2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = list2.iterator();
        while (object.hasNext()) {
            DERWriter.write(byteArrayOutputStream, (DERValue)object.next());
        }
        object = byteArrayOutputStream.toByteArray();
        DERWriter.writeLength(outputStream, ((Object)object).length);
        outputStream.write((byte[])object);
        return ((Object)object).length;
    }

    private static int writeSet(OutputStream outputStream, Set set) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Object object = set.iterator();
        while (object.hasNext()) {
            DERWriter.write(byteArrayOutputStream, (DERValue)object.next());
        }
        object = byteArrayOutputStream.toByteArray();
        DERWriter.writeLength(outputStream, ((Object)object).length);
        outputStream.write((byte[])object);
        return ((Object)object).length;
    }

    private static int writeOID(OutputStream outputStream, OID oID) throws IOException {
        byte[] byArray = oID.getDER();
        DERWriter.writeLength(outputStream, byArray.length);
        outputStream.write(byArray);
        return byArray.length;
    }

    private static int writeBitString(OutputStream outputStream, BitString bitString) throws IOException {
        byte[] byArray = bitString.getShiftedByteArray();
        DERWriter.writeLength(outputStream, byArray.length + 1);
        outputStream.write(bitString.getIgnoredBits());
        outputStream.write(byArray);
        return byArray.length + 1;
    }

    private static int writeString(OutputStream outputStream, int n, String string) throws IOException {
        byte[] byArray = null;
        switch (n & 0x1F) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: {
                byArray = DERWriter.toIso88591(string);
                break;
            }
            case 28: 
            case 30: {
                byArray = DERWriter.toUtf16Be(string);
                break;
            }
            default: {
                byArray = DERWriter.toUtf8(string);
            }
        }
        DERWriter.writeLength(outputStream, byArray.length);
        outputStream.write(byArray);
        return byArray.length;
    }

    private static byte[] toIso88591(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    private static byte[] toUtf16Be(String string) {
        byte[] byArray = new byte[string.length() * 2];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i * 2] = (byte)(string.charAt(i) >>> 8);
            byArray[i * 2 + 1] = (byte)string.charAt(i);
        }
        return byArray;
    }

    private static byte[] toUtf8(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)((double)string.length() * 1.5));
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                byteArrayOutputStream.write(c & 0xFF);
                continue;
            }
            if (c < '\u0800') {
                byteArrayOutputStream.write(0xC0 | c >>> 6 & 0x3F);
                byteArrayOutputStream.write(0x80 | c & 0x3F);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | c >>> 12 & 0xF);
            byteArrayOutputStream.write(0x80 | c >>> 6 & 0x3F);
            byteArrayOutputStream.write(0x80 | c & 0x3F);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int writeDate(OutputStream outputStream, int n, Date date) throws IOException {
        SimpleDateFormat simpleDateFormat = null;
        simpleDateFormat = (n & 0x1F) == 23 ? new SimpleDateFormat("yyMMddHHmmss'Z'") : new SimpleDateFormat("yyyyMMddHHmmss'.'SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        byte[] byArray = simpleDateFormat.format(date).getBytes("ISO-8859-1");
        DERWriter.writeLength(outputStream, byArray.length);
        outputStream.write(byArray);
        return byArray.length;
    }

    static void writeLength(OutputStream outputStream, int n) throws IOException {
        if (n < 128) {
            outputStream.write(n);
        } else if (n < 256) {
            outputStream.write(129);
            outputStream.write(n);
        } else if (n < 65536) {
            outputStream.write(130);
            outputStream.write(n >> 8);
            outputStream.write(n);
        } else if (n < 0x1000000) {
            outputStream.write(131);
            outputStream.write(n >> 16);
            outputStream.write(n >> 8);
            outputStream.write(n);
        } else {
            outputStream.write(132);
            outputStream.write(n >> 24);
            outputStream.write(n >> 16);
            outputStream.write(n >> 8);
            outputStream.write(n);
        }
    }
}

