/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenChar
extends REToken {
    private char[] ch;
    private boolean insens;

    RETokenChar(int n, char c, boolean bl) {
        super(n);
        this.insens = bl;
        this.ch = new char[1];
        this.ch[0] = c;
    }

    int getMinimumLength() {
        return this.ch.length;
    }

    int getMaximumLength() {
        return this.ch.length;
    }

    REMatch matchThis(CharIndexed charIndexed, REMatch rEMatch) {
        int n = this.ch.length;
        if (this.matchOneString(charIndexed, rEMatch.index)) {
            rEMatch.index += n;
            return rEMatch;
        }
        return null;
    }

    boolean matchOneString(CharIndexed charIndexed, int n) {
        int n2 = this.ch.length;
        for (int i = 0; i < n2; ++i) {
            char c = charIndexed.charAt(n + i);
            if (this.charEquals(c, this.ch[i])) continue;
            return false;
        }
        return true;
    }

    private boolean charEquals(char c, char c2) {
        if (c == c2) {
            return true;
        }
        if (!this.insens) {
            return false;
        }
        if (REToken.toLowerCase(c, this.unicodeAware) == c2) {
            return true;
        }
        return REToken.toUpperCase(c, this.unicodeAware) == c2;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed charIndexed, REMatch rEMatch, int n) {
        int n2;
        int n3 = rEMatch.index;
        int n4 = this.ch.length;
        for (n2 = 0; n2 < n && this.matchOneString(charIndexed, n3); ++n2) {
            n3 += n4;
        }
        return n2;
    }

    boolean chain(REToken rEToken) {
        if (rEToken instanceof RETokenChar && ((RETokenChar)rEToken).insens == this.insens) {
            RETokenChar rETokenChar = (RETokenChar)rEToken;
            int n = this.ch.length + rETokenChar.ch.length;
            char[] cArray = new char[n];
            System.arraycopy(this.ch, 0, cArray, 0, this.ch.length);
            System.arraycopy(rETokenChar.ch, 0, cArray, this.ch.length, rETokenChar.ch.length);
            this.ch = cArray;
            return false;
        }
        return super.chain(rEToken);
    }

    void dump(StringBuffer stringBuffer) {
        stringBuffer.append(this.ch);
    }
}

