/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key;

import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSKeyPairPKCS8Codec;
import gnu.java.security.key.dss.DSSKeyPairRawCodec;
import gnu.java.security.key.dss.DSSKeyPairX509Codec;
import gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec;
import gnu.java.security.key.rsa.RSAKeyPairRawCodec;
import gnu.java.security.key.rsa.RSAKeyPairX509Codec;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.key.dh.DHKeyPairPKCS8Codec;
import gnu.javax.crypto.key.dh.DHKeyPairRawCodec;
import gnu.javax.crypto.key.dh.DHKeyPairX509Codec;
import gnu.javax.crypto.key.srp6.SRPKeyPairRawCodec;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;

public class IncomingMessage {
    protected ByteArrayInputStream in;
    protected int length;

    public IncomingMessage(byte[] byArray) throws KeyAgreementException {
        this();
        if (byArray.length < 4) {
            throw new KeyAgreementException("message header too short");
        }
        this.length = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (this.length > 0x7FFFFFFB || this.length < 0) {
            throw new KeyAgreementException("message size limit exceeded");
        }
        this.in = new ByteArrayInputStream(byArray, 4, this.length);
    }

    private IncomingMessage() {
    }

    public static IncomingMessage getInstance(byte[] byArray) {
        return IncomingMessage.getInstance(byArray, 0, byArray.length);
    }

    public static IncomingMessage getInstance(byte[] byArray, int n, int n2) {
        IncomingMessage incomingMessage = new IncomingMessage();
        incomingMessage.in = new ByteArrayInputStream(byArray, n, n2);
        return incomingMessage;
    }

    public static int twoBytesToLength(byte[] byArray) throws KeyAgreementException {
        int n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        if (n > 65535) {
            throw new KeyAgreementException("encoded MPI size limit exceeded");
        }
        return n;
    }

    public static int fourBytesToLength(byte[] byArray) throws KeyAgreementException {
        int n = byArray[0] << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (n > 0x7FFFFEF7 || n < 0) {
            throw new KeyAgreementException("encoded entity size limit exceeded");
        }
        return n;
    }

    public boolean hasMoreElements() {
        return this.in.available() > 0;
    }

    public PublicKey readPublicKey() throws KeyAgreementException {
        if (this.in.available() < 5) {
            throw new KeyAgreementException("not enough bytes for a public key in message");
        }
        byte[] byArray = new byte[4];
        this.in.read(byArray, 0, 4);
        int n = IncomingMessage.fourBytesToLength(byArray);
        if (this.in.available() < n) {
            throw new KeyAgreementException("illegal public key encoding");
        }
        int n2 = this.in.read() & 0xFF;
        byte[] byArray2 = new byte[--n];
        this.in.read(byArray2, 0, n);
        IKeyPairCodec iKeyPairCodec = this.getKeyPairCodec(n2);
        return iKeyPairCodec.decodePublicKey(byArray2);
    }

    public PrivateKey readPrivateKey() throws KeyAgreementException {
        if (this.in.available() < 5) {
            throw new KeyAgreementException("not enough bytes for a private key in message");
        }
        byte[] byArray = new byte[4];
        this.in.read(byArray, 0, 4);
        int n = IncomingMessage.fourBytesToLength(byArray);
        if (this.in.available() < n) {
            throw new KeyAgreementException("illegal private key encoding");
        }
        int n2 = this.in.read() & 0xFF;
        byte[] byArray2 = new byte[--n];
        this.in.read(byArray2, 0, n);
        IKeyPairCodec iKeyPairCodec = this.getKeyPairCodec(n2);
        return iKeyPairCodec.decodePrivateKey(byArray2);
    }

    public BigInteger readMPI() throws KeyAgreementException {
        if (this.in.available() < 2) {
            throw new KeyAgreementException("not enough bytes for an MPI in message");
        }
        byte[] byArray = new byte[2];
        this.in.read(byArray, 0, 2);
        int n = IncomingMessage.twoBytesToLength(byArray);
        if (this.in.available() < n) {
            throw new KeyAgreementException("illegal MPI encoding");
        }
        byte[] byArray2 = new byte[n];
        this.in.read(byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    public String readString() throws KeyAgreementException {
        if (this.in.available() < 2) {
            throw new KeyAgreementException("not enough bytes for a text in message");
        }
        byte[] byArray = new byte[2];
        this.in.read(byArray, 0, 2);
        int n = IncomingMessage.twoBytesToLength(byArray);
        if (this.in.available() < n) {
            throw new KeyAgreementException("illegal text encoding");
        }
        byte[] byArray2 = new byte[n];
        this.in.read(byArray2, 0, byArray2.length);
        String string = null;
        try {
            string = new String(byArray2, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new KeyAgreementException("unxupported UTF8 encoding", unsupportedEncodingException);
        }
        return string;
    }

    private IKeyPairCodec getKeyPairCodec(int n) throws KeyAgreementException {
        int n2 = n >>> 4 & 0xF;
        int n3 = n & 0xF;
        switch (n3) {
            case 1: {
                switch (n2) {
                    case 0: {
                        return new DSSKeyPairRawCodec();
                    }
                    case 1: {
                        return new RSAKeyPairRawCodec();
                    }
                    case 2: {
                        return new DHKeyPairRawCodec();
                    }
                    case 3: {
                        return new SRPKeyPairRawCodec();
                    }
                }
                throw new KeyAgreementException("Unknown key-type for Raw format: " + n2);
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return new DSSKeyPairX509Codec();
                    }
                    case 1: {
                        return new RSAKeyPairX509Codec();
                    }
                    case 2: {
                        return new DHKeyPairX509Codec();
                    }
                }
                throw new KeyAgreementException("Unknown key-type for X.509 format: " + n2);
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return new DSSKeyPairPKCS8Codec();
                    }
                    case 1: {
                        return new RSAKeyPairPKCS8Codec();
                    }
                    case 2: {
                        return new DHKeyPairPKCS8Codec();
                    }
                }
                throw new KeyAgreementException("Unknown key-type for PKCS#8 format: " + n2);
            }
        }
        throw new KeyAgreementException("Unknown format identifier: " + n3);
    }
}

