/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public class ICMGenerator
extends BasePRNG
implements Cloneable {
    public static final String CIPHER = "gnu.crypto.prng.icm.cipher.name";
    public static final String BLOCK_INDEX_LENGTH = "gnu.crypto.prng.icm.block.index.length";
    public static final String SEGMENT_INDEX_LENGTH = "gnu.crypto.prng.icm.segment.index.length";
    public static final String OFFSET = "gnu.crypto.prng.icm.offset";
    public static final String SEGMENT_INDEX = "gnu.crypto.prng.icm.segment.index";
    private static final BigInteger TWO_FIFTY_SIX;
    private IBlockCipher cipher;
    private int blockNdxLength;
    private int segmentNdxLength;
    private BigInteger blockNdx;
    private BigInteger segmentNdx;
    private BigInteger C0;

    private /* synthetic */ void finit$() {
        this.blockNdxLength = -1;
        this.segmentNdxLength = -1;
        this.blockNdx = BigInteger.ZERO;
    }

    public ICMGenerator() {
        super("icm");
        this.finit$();
    }

    public void setup(Map map) {
        BigInteger bigInteger;
        boolean bl = true;
        String string = (String)map.get(CIPHER);
        if (string == null) {
            if (this.cipher == null) {
                this.cipher = CipherFactory.getInstance("rijndael");
            } else {
                bl = false;
            }
        } else {
            this.cipher = CipherFactory.getInstance(string);
        }
        int n = 0;
        Integer n2 = (Integer)map.get("gnu.crypto.cipher.block.size");
        if (n2 != null) {
            n = n2;
        } else if (bl) {
            n = this.cipher.defaultBlockSize();
        }
        byte[] byArray = (byte[])map.get("gnu.crypto.cipher.key.material");
        if (byArray == null) {
            throw new IllegalArgumentException("gnu.crypto.cipher.key.material");
        }
        HashMap hashMap = new HashMap();
        if (n != 0) {
            hashMap.put("gnu.crypto.cipher.block.size", n);
        }
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        try {
            this.cipher.init(hashMap);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException("gnu.crypto.cipher.key.material");
        }
        n = this.cipher.currentBlockSize();
        BigInteger bigInteger2 = TWO_FIFTY_SIX.pow(n);
        Object object = map.get(OFFSET);
        if (object instanceof BigInteger) {
            bigInteger = (BigInteger)object;
        } else {
            byte[] byArray2 = (byte[])object;
            if (byArray2.length != n) {
                throw new IllegalArgumentException(OFFSET);
            }
            bigInteger = new BigInteger(1, byArray2);
        }
        int n3 = -1;
        Integer n4 = (Integer)map.get(BLOCK_INDEX_LENGTH);
        if (n4 != null && (n3 = n4.intValue()) < 1) {
            throw new IllegalArgumentException(BLOCK_INDEX_LENGTH);
        }
        int n5 = -1;
        n4 = (Integer)map.get(SEGMENT_INDEX_LENGTH);
        if (n4 != null && (n5 = n4.intValue()) < 1) {
            throw new IllegalArgumentException(SEGMENT_INDEX_LENGTH);
        }
        if (n3 == -1 && n5 == -1) {
            if (this.blockNdxLength == -1) {
                throw new IllegalArgumentException("gnu.crypto.prng.icm.block.index.length, gnu.crypto.prng.icm.segment.index.length");
            }
        } else {
            int n6 = n / 2;
            if (n3 == -1) {
                n3 = n6 - n5;
            } else if (n5 == -1) {
                n5 = n6 - n3;
            } else if (n5 + n3 > n6) {
                throw new IllegalArgumentException("gnu.crypto.prng.icm.block.index.length, gnu.crypto.prng.icm.segment.index.length");
            }
            this.blockNdxLength = n3;
            this.segmentNdxLength = n5;
        }
        BigInteger bigInteger3 = (BigInteger)map.get(SEGMENT_INDEX);
        if (bigInteger3 == null) {
            if (this.segmentNdx == null) {
                throw new IllegalArgumentException(SEGMENT_INDEX);
            }
            if (this.segmentNdx.compareTo(TWO_FIFTY_SIX.pow(this.segmentNdxLength)) > 0) {
                throw new IllegalArgumentException(SEGMENT_INDEX);
            }
        } else {
            if (bigInteger3.compareTo(TWO_FIFTY_SIX.pow(this.segmentNdxLength)) > 0) {
                throw new IllegalArgumentException(SEGMENT_INDEX);
            }
            this.segmentNdx = bigInteger3;
        }
        this.C0 = this.segmentNdx.multiply(TWO_FIFTY_SIX.pow(this.blockNdxLength)).add(bigInteger).modPow(BigInteger.ONE, bigInteger2);
    }

    public void fillBlock() throws LimitReachedException {
        if (this.C0 == null) {
            throw new IllegalStateException();
        }
        if (this.blockNdx.compareTo(TWO_FIFTY_SIX.pow(this.blockNdxLength)) >= 0) {
            throw new LimitReachedException();
        }
        int n = this.cipher.currentBlockSize();
        BigInteger bigInteger = TWO_FIFTY_SIX.pow(n);
        BigInteger bigInteger2 = this.C0.add(this.blockNdx).modPow(BigInteger.ONE, bigInteger);
        this.buffer = bigInteger2.toByteArray();
        int n2 = this.buffer.length;
        if (n2 < n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, 0, byArray, n - n2, n2);
            this.buffer = byArray;
        } else if (n2 > n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, n2 - n, byArray, 0, n);
            this.buffer = byArray;
        }
        this.cipher.encryptBlock(this.buffer, 0, this.buffer, 0);
        this.blockNdx = this.blockNdx.add(BigInteger.ONE);
    }

    static {
        CIPHER = CIPHER;
        BLOCK_INDEX_LENGTH = BLOCK_INDEX_LENGTH;
        SEGMENT_INDEX_LENGTH = SEGMENT_INDEX_LENGTH;
        OFFSET = OFFSET;
        SEGMENT_INDEX = SEGMENT_INDEX;
        TWO_FIFTY_SIX = new BigInteger("256");
    }
}

