/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.crammd5;

import gnu.java.security.util.Util;
import gnu.javax.crypto.sasl.NoSuchUserException;
import gnu.javax.crypto.sasl.ServerMechanism;
import gnu.javax.crypto.sasl.crammd5.CramMD5Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class CramMD5Server
extends ServerMechanism
implements SaslServer {
    private byte[] msgID;

    public CramMD5Server() {
        super("CRAM-MD5");
    }

    protected void initMechanism() throws SaslException {
    }

    protected void resetMechanism() throws SaslException {
    }

    public byte[] evaluateResponse(byte[] byArray) throws SaslException {
        byte[] byArray2;
        byte[] byArray3;
        if (this.state == 0) {
            this.msgID = CramMD5Util.createMsgID();
            ++this.state;
            return this.msgID;
        }
        String string = new String(byArray);
        int n = string.lastIndexOf(" ");
        String string2 = string.substring(0, n);
        try {
            byArray3 = string.substring(n + 1).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("evaluateResponse()", unsupportedEncodingException);
        }
        char[] cArray = this.lookupPassword(string2);
        try {
            byArray2 = CramMD5Util.createHMac(cArray, this.msgID);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException("evaluateResponse()", invalidKeyException);
        }
        try {
            byArray2 = Util.toString(byArray2).toLowerCase().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationException("evaluateResponse()", unsupportedEncodingException);
        }
        if (!Arrays.equals(byArray2, byArray3)) {
            throw new AuthenticationException("Digest mismatch");
        }
        ++this.state;
        return null;
    }

    public boolean isComplete() {
        return this.state == 2;
    }

    protected String getNegotiatedQOP() {
        return "auth";
    }

    private char[] lookupPassword(String string) throws SaslException {
        try {
            if (!this.authenticator.contains(string)) {
                throw new NoSuchUserException(string);
            }
            HashMap hashMap = new HashMap();
            hashMap.put("gnu.crypto.sasl.username", string);
            Map map = this.authenticator.lookup(hashMap);
            String string2 = (String)map.get("gnu.crypto.sasl.password");
            if (string2 == null) {
                throw new AuthenticationException("lookupPassword()", new InternalError());
            }
            return string2.toCharArray();
        }
        catch (IOException iOException) {
            if (iOException instanceof SaslException) {
                throw (SaslException)iOException;
            }
            throw new AuthenticationException("lookupPassword()", iOException);
        }
    }
}

