/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.sampled.WAV;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class WAVReader
extends AudioFileReader {
    private static long readUnsignedIntLE(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray);
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    private static short readUnsignedShortLE(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[2];
        dataInputStream.readFully(byArray);
        return (short)((short)byArray[0] & 0xFF | (short)((byArray[1] & 0xFF) << 8));
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            audioFileFormat = this.getAudioFileFormat(fileInputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding;
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        if (dataInputStream.readInt() != 1380533830) {
            throw new UnsupportedAudioFileException("Invalid WAV chunk header.");
        }
        WAVReader.readUnsignedIntLE(dataInputStream);
        if (dataInputStream.readInt() != 1463899717) {
            throw new UnsupportedAudioFileException("Invalid WAV chunk header.");
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        short s = 0;
        short s2 = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        block5: while (!bl2) {
            int n3 = dataInputStream.readInt();
            l3 = WAVReader.readUnsignedIntLE(dataInputStream);
            switch (n3) {
                case 1718449184: {
                    bl = true;
                    n = WAVReader.readUnsignedShortLE(dataInputStream);
                    s = WAVReader.readUnsignedShortLE(dataInputStream);
                    l = WAVReader.readUnsignedIntLE(dataInputStream);
                    l2 = WAVReader.readUnsignedIntLE(dataInputStream);
                    s2 = WAVReader.readUnsignedShortLE(dataInputStream);
                    n2 = WAVReader.readUnsignedShortLE(dataInputStream);
                    dataInputStream.skip(l3 - (long)16);
                    continue block5;
                }
                case 1717658484: {
                    dataInputStream.skip(l3);
                    continue block5;
                }
                case 1684108385: {
                    if (!bl) {
                        throw new UnsupportedAudioFileException("This implementation requires WAV fmt chunks precede data chunks.");
                    }
                    bl2 = true;
                    continue block5;
                }
            }
            dataInputStream.skip(l3);
        }
        if (n == 1) {
            encoding = n2 <= 8 ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED;
        } else {
            throw new UnsupportedAudioFileException("Unrecognized WAV compression code: 0x" + Integer.toHexString(n));
        }
        return new AudioFileFormat(AudioFileFormat.Type.WAVE, new AudioFormat(encoding, l, n2, s, (n2 + 7) / 8 * s, l2, false), (int)l3);
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat;
        InputStream inputStream = uRL.openStream();
        try {
            audioFileFormat = this.getAudioFileFormat(inputStream);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(new FileInputStream(file));
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(uRL.openStream());
    }
}

