/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Key;
import gnu.xml.transform.SortKey;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.WithParam;
import gnu.xml.transform.XSLComparator;
import gnu.xml.xpath.Expr;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class ApplyTemplatesNode
extends TemplateNode {
    final Expr select;
    final QName mode;
    final List sortKeys;
    final List withParams;
    final boolean isDefault;

    ApplyTemplatesNode(Expr expr, QName qName, List list2, List list3, boolean bl) {
        this.select = expr;
        this.mode = qName;
        this.sortKeys = list2;
        this.withParams = list3;
        this.isDefault = bl;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        int n = this.sortKeys != null ? this.sortKeys.size() : 0;
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(((Key)this.sortKeys.get(i)).clone(stylesheet));
        }
        n = this.withParams != null ? this.withParams.size() : 0;
        ArrayList arrayList2 = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(((WithParam)this.withParams.get(i)).clone(stylesheet));
        }
        ApplyTemplatesNode applyTemplatesNode = new ApplyTemplatesNode(this.select.clone(stylesheet), this.mode, arrayList, arrayList2, this.isDefault);
        if (this.children != null) {
            applyTemplatesNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            applyTemplatesNode.next = this.next.clone(stylesheet);
        }
        return applyTemplatesNode;
    }

    void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        Object object = this.select.evaluate(node2, n, n2);
        if (object != null && object instanceof Collection) {
            Object object2;
            Object[] objectArray;
            Object object3;
            Collection collection;
            if (this.withParams != null) {
                Object object4;
                collection = new LinkedList();
                object3 = this.withParams.iterator();
                while (object3.hasNext()) {
                    objectArray = (WithParam)object3.next();
                    object2 = objectArray.getValue(stylesheet, qName, node2, n, n2);
                    object4 = new Object[]{objectArray.name, object2};
                    ((LinkedList)collection).add(object4);
                }
                stylesheet.bindings.push(2);
                object3 = ((AbstractSequentialList)collection).iterator();
                while (object3.hasNext()) {
                    objectArray = (Object[])object3.next();
                    object2 = (QName)objectArray[0];
                    object4 = objectArray[1];
                    stylesheet.bindings.set((QName)object2, object4, 2);
                }
            }
            collection = (Collection)object;
            object3 = new ArrayList(collection);
            if (this.sortKeys != null) {
                objectArray = this.sortKeys.iterator();
                while (objectArray.hasNext()) {
                    object2 = (SortKey)objectArray.next();
                    ((SortKey)object2).init(stylesheet, qName, node2, n, n2, node3, node4);
                }
                Collections.sort((List)object3, new XSLComparator(this.sortKeys));
            } else {
                Collections.sort((List)object3, TemplateNode.documentOrderComparator);
            }
            int n3 = object3.size();
            object2 = this.isDefault ? qName : this.mode;
            for (int i = 0; i < n3; ++i) {
                Node node5 = (Node)object3.get(i);
                TemplateNode templateNode = stylesheet.getTemplate((QName)object2, node5, false);
                if (templateNode == null) continue;
                stylesheet.current = node5;
                templateNode.apply(stylesheet, (QName)object2, node5, i + 1, n3, node3, node4);
            }
            if (this.withParams != null) {
                stylesheet.bindings.pop(2);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    public boolean references(QName qName) {
        Iterator iterator;
        if (this.select != null && this.select.references(qName)) {
            return true;
        }
        if (this.withParams != null) {
            iterator = this.withParams.iterator();
            while (iterator.hasNext()) {
                if (!((WithParam)iterator.next()).references(qName)) continue;
                return true;
            }
        }
        if (this.sortKeys != null) {
            iterator = this.sortKeys.iterator();
            while (iterator.hasNext()) {
                if (!((SortKey)iterator.next()).references(qName)) continue;
                return true;
            }
        }
        return super.references(qName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("apply-templates");
        stringBuffer.append('[');
        boolean bl = false;
        if (this.select != null) {
            stringBuffer.append("select=");
            stringBuffer.append(this.select);
            bl = true;
        }
        if (this.mode != null) {
            if (bl) {
                stringBuffer.append(',');
            }
            stringBuffer.append("mode=");
            stringBuffer.append(this.mode);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

