/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

public class Checkbox
extends Component
implements ItemSelectable,
Accessible,
Serializable {
    private static final long serialVersionUID = 7270714317450821763L;
    private CheckboxGroup group;
    private String label;
    boolean state;
    private transient ItemListener item_listeners;
    private static transient long next_checkbox_number;

    public Checkbox() {
        this("", false, null);
    }

    public Checkbox(String string) {
        this(string, false, null);
    }

    public Checkbox(String string, boolean bl) {
        this(string, bl, null);
    }

    public Checkbox(String string, CheckboxGroup checkboxGroup, boolean bl) {
        this(string, bl, checkboxGroup);
    }

    public Checkbox(String string, boolean bl, CheckboxGroup checkboxGroup) {
        this.label = string;
        this.state = bl;
        this.group = checkboxGroup;
        if (bl && checkboxGroup != null) {
            checkboxGroup.setSelectedCheckbox(this);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        if (this.peer != null) {
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            checkboxPeer.setLabel(string);
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean bl) {
        if (this.state != bl) {
            this.state = bl;
            if (this.peer != null) {
                CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
                checkboxPeer.setState(bl);
            }
        }
    }

    public Object[] getSelectedObjects() {
        if (!this.state) {
            return null;
        }
        Object[] objectArray = new Object[]{this.label};
        return objectArray;
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public synchronized void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        this.group = checkboxGroup;
        if (this.peer != null) {
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            checkboxPeer.setCheckboxGroup(checkboxGroup);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckbox(this);
        }
        super.addNotify();
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners(this.item_listeners, Checkbox.class$("java.awt.event.ItemListener"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 701 && aWTEvent.id >= 701) {
            ItemEvent itemEvent = (ItemEvent)aWTEvent;
            int n = itemEvent.getStateChange();
            this.setState(n == 1);
            if (this.item_listeners != null || (this.eventMask & (long)512) != 0L) {
                this.processEvent(aWTEvent);
            }
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected String paramString() {
        return "label=" + this.label + ",state=" + this.state + "," + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleAWTCheckbox accessibleAWTCheckbox = new AccessibleAWTCheckbox(this);
            this.accessibleContext = accessibleAWTCheckbox;
            this.addItemListener(accessibleAWTCheckbox);
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "checkbox" + Checkbox.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_checkbox_number++;
    }

    protected class AccessibleAWTCheckbox
    extends Component.AccessibleAWTComponent
    implements ItemListener,
    AccessibleAction,
    AccessibleValue {
        private /* synthetic */ Checkbox this$0;
        private static final long serialVersionUID = 7881579233144754107L;

        public AccessibleAWTCheckbox(Checkbox checkbox) {
            this.this$0 = checkbox;
            super(checkbox);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.firePropertyChange("AccessibleState", this.this$0.state ? null : AccessibleState.CHECKED, this.this$0.state ? AccessibleState.CHECKED : null);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int n) {
            return null;
        }

        public boolean doAccessibleAction(int n) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.state) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }
    }
}

