/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

public class EventQueue {
    private static final int INITIAL_QUEUE_DEPTH = 8;
    private AWTEvent[] queue;
    private int next_in;
    private int next_out;
    private EventQueue next;
    private EventQueue prev;
    private AWTEvent currentEvent;
    private long lastWhen;
    private EventDispatchThread dispatchThread;
    private boolean shutdown;

    private /* synthetic */ void finit$() {
        this.queue = new AWTEvent[8];
        this.next_in = 0;
        this.next_out = 0;
        this.lastWhen = System.currentTimeMillis();
        this.dispatchThread = new EventDispatchThread(this);
        this.shutdown = false;
    }

    private synchronized void setShutdown(boolean bl) {
        this.shutdown = bl;
    }

    synchronized boolean isShutdown() {
        if (this.shutdown) {
            return true;
        }
        if (this.peekEvent() == null) {
            Frame[] frameArray = Frame.getFrames();
            for (int i = 0; i < frameArray.length; ++i) {
                if (!frameArray[i].isDisplayable()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public EventQueue() {
        this.finit$();
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        if (this.next != null) {
            return this.next.getNextEvent();
        }
        while (this.next_in == this.next_out) {
            if (this.isShutdown()) {
                throw new InterruptedException();
            }
            this.wait();
        }
        AWTEvent aWTEvent = this.queue[this.next_out];
        if (++this.next_out == this.queue.length) {
            this.next_out = 0;
        }
        return aWTEvent;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.next != null) {
            return this.next.peekEvent();
        }
        if (this.next_in != this.next_out) {
            return this.queue[this.next_out];
        }
        return null;
    }

    public synchronized AWTEvent peekEvent(int n) {
        if (this.next != null) {
            return this.next.peekEvent(n);
        }
        int n2 = this.next_out;
        while (n2 != this.next_in) {
            AWTEvent aWTEvent = this.queue[n2];
            if (aWTEvent.id != n) continue;
            return aWTEvent;
        }
        return null;
    }

    public synchronized void postEvent(AWTEvent aWTEvent) {
        AWTEvent[] aWTEventArray;
        if (aWTEvent == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.postEvent(aWTEvent);
            return;
        }
        int n = this.next_out;
        while (n != this.next_in) {
            Object object;
            aWTEventArray = this.queue[n];
            if (aWTEventArray.id == aWTEvent.id && (object = aWTEventArray.getSource()) == aWTEvent.getSource() && object instanceof Component) {
                Component component = (Component)object;
                AWTEvent aWTEvent2 = component.coalesceEvents((AWTEvent)aWTEventArray, aWTEvent);
                if (aWTEvent2 == null) break;
                this.queue[n] = aWTEvent2;
                return;
            }
            if (++n != this.queue.length) continue;
            n = 0;
        }
        this.queue[this.next_in] = aWTEvent;
        if (++this.next_in == this.queue.length) {
            this.next_in = 0;
        }
        if (this.next_in == this.next_out) {
            aWTEventArray = this.queue;
            this.queue = new AWTEvent[this.queue.length * 2];
            int n2 = aWTEventArray.length - this.next_out;
            System.arraycopy(aWTEventArray, this.next_out, this.queue, 0, n2);
            if (this.next_out != 0) {
                System.arraycopy(aWTEventArray, 0, this.queue, n2, this.next_out);
            }
            this.next_out = 0;
            this.next_in = aWTEventArray.length;
        }
        if (this.dispatchThread == null || !this.dispatchThread.isAlive()) {
            this.dispatchThread = new EventDispatchThread(this);
            this.dispatchThread.start();
        }
        this.notify();
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Can't call invokeAndWait from event dispatch thread");
        }
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread thread = Thread.currentThread();
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, thread, true);
        Thread thread2 = thread;
        synchronized (thread2) {
            Exception exception;
            try {
                eventQueue.postEvent(invocationEvent);
                thread.wait();
            }
            finally {
                exception = null;
            }
            exception = invocationEvent.getException();
            if (exception != null) {
                throw new InvocationTargetException(exception);
            }
            return;
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        InvocationEvent invocationEvent = new InvocationEvent(eventQueue, runnable, null, false);
        eventQueue.postEvent(invocationEvent);
    }

    public static boolean isDispatchThread() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eventQueue.next != null) {
            eventQueue = eventQueue.next;
        }
        return Thread.currentThread() == eventQueue.dispatchThread;
    }

    public static AWTEvent getCurrentEvent() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread thread = Thread.currentThread();
        while (thread != eventQueue.dispatchThread) {
            if (eventQueue.next == null) {
                return null;
            }
            eventQueue = eventQueue.next;
        }
        return eventQueue.currentEvent;
    }

    public synchronized void push(EventQueue eventQueue) {
        if (eventQueue == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.push(eventQueue);
            return;
        }
        if (this.dispatchThread == null) {
            this.dispatchThread = new EventDispatchThread(this);
        }
        int n = this.next_out;
        while (n != this.next_in) {
            eventQueue.postEvent(this.queue[n]);
            this.next_out = n++;
            if (n != this.queue.length) continue;
            n = 0;
        }
        this.next = eventQueue;
        eventQueue.prev = this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void pop() throws EmptyStackException {
        if (this.prev == null) {
            throw new EmptyStackException();
        }
        EventQueue eventQueue = this.prev;
        synchronized (eventQueue) {
            try {
                this.prev.next = this.next;
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                EventQueue eventQueue2 = this;
                synchronized (eventQueue2) {
                    try {
                        int n = this.next_out;
                        while (n != this.next_in) {
                            this.prev.postEvent(this.queue[n]);
                            this.next_out = n++;
                            if (n != this.queue.length) continue;
                            n = 0;
                        }
                        this.next_in = 0;
                        this.next_out = 0;
                        this.setShutdown(true);
                        this.dispatchThread = null;
                        this.notifyAll();
                        return;
                    }
                    finally {
                        Object var3_4 = null;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
        }
    }

    protected void dispatchEvent(AWTEvent aWTEvent) {
        this.currentEvent = aWTEvent;
        if (aWTEvent instanceof InputEvent) {
            this.lastWhen = ((InputEvent)aWTEvent).getWhen();
        } else if (aWTEvent instanceof ActionEvent) {
            this.lastWhen = ((ActionEvent)aWTEvent).getWhen();
        } else if (aWTEvent instanceof InvocationEvent) {
            this.lastWhen = ((InvocationEvent)aWTEvent).getWhen();
        }
        if (aWTEvent instanceof ActiveEvent) {
            ActiveEvent activeEvent = (ActiveEvent)((Object)aWTEvent);
            activeEvent.dispatch();
        } else {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)object;
                component.dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                MenuComponent menuComponent = (MenuComponent)object;
                menuComponent.dispatchEvent(aWTEvent);
            }
        }
    }

    public static long getMostRecentEventTime() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (Thread.currentThread() != eventQueue.dispatchThread) {
            return System.currentTimeMillis();
        }
        return eventQueue.lastWhen;
    }
}

