/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import gnu.java.awt.EventModifier;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class MouseEvent
extends InputEvent {
    private static final long serialVersionUID = -991214153494842848L;
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 507;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int NOBUTTON = 0;
    public static final int BUTTON1 = 1;
    public static final int BUTTON2 = 2;
    public static final int BUTTON3 = 3;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    private int x;
    private int y;
    private final int clickCount;
    private int button;
    private final boolean popupTrigger;

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        super(component, n, l, n2);
        this.x = n3;
        this.y = n4;
        this.clickCount = n5;
        this.popupTrigger = bl;
        this.button = n6;
        if (n6 < 0 || n6 > 3) {
            throw new IllegalArgumentException();
        }
        if ((n2 & 0x3F) != 0) {
            if ((n2 & 0x10) != 0) {
                this.button = 1;
            } else if ((n2 & 8) != 0) {
                this.button = 2;
            } else if ((n2 & 4) != 0) {
                this.button = 3;
            }
        }
        if (n == 502) {
            this.modifiersEx &= 0xFFFFE3FF;
        }
    }

    public MouseEvent(Component component, int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        this(component, n, l, n2, n3, n4, n5, bl, 0);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public void translatePoint(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public int getButton() {
        return this.button;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public static String getMouseModifiersText(int n) {
        if (((n &= 0x3F) & 8) != 0) {
            n |= 0x800;
        }
        if ((n & 4) != 0) {
            n |= 0x1000;
        }
        return InputEvent.getModifiersExText(EventModifier.extend(n));
    }

    public String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.id) {
            case 500: {
                stringBuffer.append("MOUSE_CLICKED,(");
                break;
            }
            case 501: {
                stringBuffer.append("MOUSE_PRESSED,(");
                break;
            }
            case 502: {
                stringBuffer.append("MOUSE_RELEASED,(");
                break;
            }
            case 503: {
                stringBuffer.append("MOUSE_MOVED,(");
                break;
            }
            case 504: {
                stringBuffer.append("MOUSE_ENTERED,(");
                break;
            }
            case 505: {
                stringBuffer.append("MOUSE_EXITED,(");
                break;
            }
            case 506: {
                stringBuffer.append("MOUSE_DRAGGED,(");
                break;
            }
            case 507: {
                stringBuffer.append("MOUSE_WHEEL,(");
                break;
            }
            default: {
                stringBuffer.append("unknown type,(");
            }
        }
        stringBuffer.append(this.x).append(',').append(this.y).append("),button=").append(this.button);
        if (this.modifiersEx != 0) {
            stringBuffer.append(",extModifiers=").append(InputEvent.getModifiersExText(this.modifiersEx));
        }
        stringBuffer.append(",clickCount=").append(this.clickCount);
        stringBuffer.append(",consumed=").append(this.consumed);
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if ((this.modifiers & 0x3F) != 0) {
            if ((this.modifiers & 0x10) != 0) {
                this.button = 1;
            } else if ((this.modifiers & 8) != 0) {
                this.button = 2;
            } else if ((this.modifiers & 4) != 0) {
                this.button = 3;
            }
            this.modifiersEx = EventModifier.extend(this.modifiers) & 0x3FC0;
        }
    }
}

