/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.math.BigInteger;

public class IndexColorModel
extends ColorModel {
    private int map_size;
    private boolean opaque;
    private int trans;
    private int[] rgb;
    private BigInteger validBits;

    private /* synthetic */ void finit$() {
        this.trans = -1;
        this.validBits = BigInteger.ZERO;
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this(n, n2, byArray, byArray2, byArray3, null);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n, ColorModel.nArray(8, n3 >= 0 && n3 < n2 ? 4 : 3), ColorSpace.getInstance(1000), n3 >= 0 && n3 < n2, false, 1, Buffers.smallestAppropriateTransferType(n));
        this.finit$();
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        if (n3 >= 0 && n3 < n2) {
            this.trans = n3;
            this.transparency = 2;
        }
        this.rgb = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.rgb[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n, ColorModel.nArray(8, byArray4 == null ? 3 : 4), ColorSpace.getInstance(1000), byArray4 != null, false, 3, Buffers.smallestAppropriateTransferType(n));
        this.finit$();
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = byArray4 == null;
        this.rgb = new int[n2];
        if (byArray4 == null) {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = 0xFF000000 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
            }
            this.transparency = 1;
        } else {
            int n3 = 0;
            int n4 = -1;
            for (int i = 0; i < n2; ++i) {
                n3 = byArray4[i] | n3;
                n4 = byArray4[i] & n4;
                this.rgb[i] = (byArray4[i] & 0xFF) << 24 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
            }
            this.transparency = n3 == 0 || n4 == -1 ? 2 : 3;
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        super(n, ColorModel.nArray(8, bl || n4 >= 0 && n4 < n2 ? 4 : 3), ColorSpace.getInstance(1000), bl || n4 >= 0 && n4 < n2, false, 1, Buffers.smallestAppropriateTransferType(n));
        this.finit$();
        if (n < 1) {
            throw new IllegalArgumentException("bits < 1");
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = bl ^ true;
        if (n4 >= 0 && n4 < n2) {
            this.trans = n4;
        }
        this.rgb = new int[n2];
        if (bl) {
            int n5 = 0;
            int n6 = 255;
            for (int i = 0; i < n2; ++i) {
                int n7 = byArray[4 * i + 3 + n3] & 0xFF;
                n5 |= n7;
                n6 &= n7;
                this.rgb[i] = n7 << 24 | (byArray[4 * i + n3] & 0xFF) << 16 | (byArray[4 * i + 1 + n3] & 0xFF) << 8 | byArray[4 * i + 2 + n3] & 0xFF;
            }
            this.transparency = n5 == 0 ? 2 : (n6 == 255 ? (n4 != -1 ? 2 : 1) : 3);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = 0xFF000000 | (byArray[3 * i + n3] & 0xFF) << 16 | (byArray[3 * i + 1 + n3] & 0xFF) << 8 | byArray[3 * i + 2 + n3] & 0xFF;
            }
            if (n4 != -1) {
                this.transparency = 2;
            }
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5) {
        super(n, ColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, n5);
        this.finit$();
        if (n5 != 0 && n5 != 1) {
            throw new IllegalArgumentException();
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = bl ^ true;
        if (n4 >= 0 && n4 < n2) {
            this.trans = n4;
        }
        this.rgb = new int[n2];
        if (!bl) {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = nArray[i + n3] | 0xFF000000;
            }
        } else {
            System.arraycopy(nArray, n3, this.rgb, 0, n2);
        }
        this.validBits = this.validBits.setBit(n2).subtract(BigInteger.ONE);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, int n4, BigInteger bigInteger) {
        super(n, ColorModel.nArray(8, 4), ColorSpace.getInstance(1000), true, false, 3, n4);
        this.finit$();
        if (n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException();
        }
        if (n > 16) {
            throw new IllegalArgumentException("bits > 16");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.map_size = n2;
        this.opaque = false;
        this.trans = -1;
        this.validBits = bigInteger;
        this.rgb = new int[n2];
        if (!this.hasAlpha) {
            for (int i = 0; i < n2; ++i) {
                this.rgb[i] = nArray[i + n3] | 0xFF000000;
            }
        } else {
            System.arraycopy(nArray, n3, this.rgb, 0, n2);
        }
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.trans;
    }

    public final void getReds(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)((0xFF0000 & this.rgb[i]) >> 16);
        }
    }

    public final void getGreens(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)((0xFF00 & this.rgb[i]) >> 8);
        }
    }

    public final void getBlues(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)this.rgb[i];
        }
    }

    public final void getAlphas(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = i == this.trans ? (byte)0 : (byte)((0xFF000000 & this.rgb[i]) >> 24);
        }
    }

    public final int getRed(int n) {
        if (n < this.map_size) {
            return (0xFF0000 & this.rgb[n]) >> 16;
        }
        return 0;
    }

    public final int getGreen(int n) {
        if (n < this.map_size) {
            return (0xFF00 & this.rgb[n]) >> 8;
        }
        return 0;
    }

    public final int getBlue(int n) {
        if (n < this.map_size) {
            return 0xFF & this.rgb[n];
        }
        return 0;
    }

    public final int getAlpha(int n) {
        if (this.opaque && n != this.trans) {
            return 255;
        }
        if (n == this.trans && this.trans != -1 || n >= this.map_size) {
            return 0;
        }
        return (0xFF000000 & this.rgb[n]) >> 24;
    }

    public final int getRGB(int n) {
        if (n >= 0 && n < this.map_size) {
            return this.rgb[n];
        }
        return 0;
    }

    public final void getRGBs(int[] nArray) {
        System.arraycopy(this.rgb, 0, nArray, 0, this.map_size);
    }

    public boolean isValid(int n) {
        if (n >= 0) {
            return this.validBits.testBit(n);
        }
        return false;
    }

    public boolean isValid() {
        BigInteger bigInteger = new BigInteger("0");
        bigInteger = bigInteger.setBit(this.map_size);
        bigInteger = bigInteger.subtract(new BigInteger("1"));
        return bigInteger.equals(this.validBits);
    }

    public BigInteger getValidPixels() {
        return this.validBits;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl) {
        int n = bl ? 2 : (this.opaque && this.trans == -1 ? 1 : 2);
        BufferedImage bufferedImage = new BufferedImage(raster.width, raster.height, n);
        for (int i = raster.minX; i < raster.width + raster.minX; ++i) {
            for (int j = raster.minY; j < raster.height + raster.minY; ++j) {
                bufferedImage.setRGB(i, j, this.rgb[raster.getSample(i, j, 0)]);
            }
        }
        return bufferedImage;
    }
}

