/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;

public final class SocketPermission
extends Permission
implements Serializable {
    static final long serialVersionUID = -7204263841984476862L;
    private transient String hostname;
    private transient InetAddress address;
    private transient int minport;
    private transient int maxport;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = Integer.MAX_VALUE;
    private String actions;
    private transient int actionmask;
    private static final String[] ACTIONS = new String[]{"connect", "listen", "accept", "resolve"};

    private /* synthetic */ void finit$() {
        this.hostname = null;
        this.address = null;
    }

    public SocketPermission(String string, String string2) {
        super(SocketPermission.processHostport(string));
        this.finit$();
        this.setHostPort(this.getName());
        this.setActions(string2);
    }

    private static String processHostport(String string) {
        int n;
        if (string.length() == 0) {
            return "localhost";
        }
        if (string.charAt(0) == '[') {
            return string;
        }
        int n2 = 0;
        boolean bl = true;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == ':') {
                if (!bl) {
                    throw new IllegalArgumentException("Ambiguous hostport part");
                }
                ++n2;
                bl = false;
                continue;
            }
            bl = true;
        }
        switch (n2) {
            case 0: 
            case 1: {
                return string;
            }
            case 7: {
                return "[" + string + "]";
            }
            case 8: {
                n = string.lastIndexOf(58);
                return "[" + string.substring(0, n) + "]" + string.substring(n);
            }
        }
        throw new IllegalArgumentException("Ambiguous hostport part");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setHostPort(String string) {
        String string2;
        int n;
        if (string.charAt(0) == '[') {
            n = string.indexOf("]");
            if (n == -1) {
                throw new IllegalArgumentException("Unmatched '['");
            }
            String string3 = string.substring(1, n);
            this.address = InetAddress.getByLiteral(string3);
            if (this.address == null) {
                throw new IllegalArgumentException("Bad IPv6 address");
            }
            if (n == string.length() - 1) {
                string2 = "";
            } else {
                if (string.charAt(n + 1) != ':') throw new IllegalArgumentException("Bad character after ']'");
                string2 = string.substring(n + 2);
            }
        } else {
            String string4;
            n = string.indexOf(":");
            if (n == -1) {
                string4 = string;
                string2 = "";
            } else {
                string4 = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
            this.address = InetAddress.getByLiteral(string4);
            if (this.address == null) {
                if (string4.lastIndexOf(42) > 0) {
                    throw new IllegalArgumentException("Bad hostname");
                }
                this.hostname = string4;
            }
        }
        if (string2.length() == 0) {
            this.minport = 0;
            this.maxport = Integer.MAX_VALUE;
            return;
        } else {
            n = string2.indexOf("-");
            if (n == -1) {
                this.minport = this.maxport = Integer.parseInt(string2);
                return;
            } else {
                if (string2.indexOf("-", n + 1) != -1) {
                    throw new IllegalArgumentException("Unexpected '-'");
                }
                if (n == 0) {
                    this.minport = 0;
                    this.maxport = Integer.parseInt(string2.substring(1));
                    return;
                } else if (n == string2.length() - 1) {
                    this.minport = Integer.parseInt(string2.substring(0, string2.length() - 1));
                    this.maxport = Integer.MAX_VALUE;
                    return;
                } else {
                    this.minport = Integer.parseInt(string2.substring(0, n));
                    this.maxport = Integer.parseInt(string2.substring(n + 1));
                }
            }
        }
    }

    private void setActions(String string) {
        this.actionmask = 0;
        boolean bl = false;
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim().toLowerCase();
            this.setAction(string2);
            if (string2.equals("resolve")) {
                bl2 = true;
                continue;
            }
            bl = true;
        }
        if (bl && !bl2) {
            this.setAction("resolve");
        }
    }

    private void setAction(String string) {
        for (int i = 0; i < ACTIONS.length; ++i) {
            if (!string.equals(ACTIONS[i])) continue;
            this.actionmask |= 1 << (i & 0x1F);
            return;
        }
        throw new IllegalArgumentException("Unknown action " + string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)object;
        if (socketPermission.actionmask != this.actionmask || socketPermission.minport != this.minport || socketPermission.maxport != this.maxport) {
            return false;
        }
        if (this.address != null) {
            if (socketPermission.address == null) {
                return false;
            }
            return socketPermission.address.equals(this.address);
        }
        if (socketPermission.hostname == null) {
            return false;
        }
        return socketPermission.hostname.equals(this.hostname);
    }

    public int hashCode() {
        int n = this.actionmask + this.minport + this.maxport;
        n = this.address != null ? (n += this.address.hashCode()) : (n += this.hostname.hashCode());
        return n;
    }

    public String getActions() {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < ACTIONS.length; ++i) {
            if ((this.actionmask & 1 << (i & 0x1F)) == 0) continue;
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(ACTIONS[i]);
        }
        return stringBuffer.toString();
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private InetAddress[] getAddresses() {
        if (this.address != null) {
            return new InetAddress[]{this.address};
        }
        try {
            return InetAddress.getAllByName(this.hostname);
        }
        catch (UnknownHostException unknownHostException) {
            return new InetAddress[0];
        }
    }

    private String getCanonicalHostName() {
        if (this.address != null) {
            return this.address.internalGetCanonicalHostName();
        }
        if (this.hostname.charAt(0) == '*') {
            return null;
        }
        try {
            return InetAddress.getByName(this.hostname).internalGetCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public boolean implies(Permission permission) {
        Object object;
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        if (socketPermission.hostname != null && socketPermission.hostname.length() == 0) {
            return false;
        }
        if ((socketPermission.actionmask & this.actionmask) != socketPermission.actionmask) {
            return false;
        }
        if (socketPermission.minport < this.minport || socketPermission.maxport > this.maxport) {
            return false;
        }
        String string = null;
        if (this.address != null) {
            object = socketPermission.getAddresses();
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                if (!this.address.equals(object[i])) continue;
                return true;
            }
        }
        if (this.hostname != null && this.hostname.charAt(0) == '*' && (string = socketPermission.getCanonicalHostName()) != null && string.endsWith(this.hostname.substring(1))) {
            return true;
        }
        if (this.address == null) {
            object = socketPermission.getAddresses();
            InetAddress[] inetAddressArray = socketPermission.getAddresses();
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                for (int j = 0; j < inetAddressArray.length; ++j) {
                    if (!((InetAddress)object[i]).equals(inetAddressArray[j])) continue;
                    return true;
                }
            }
        }
        if ((object = this.getCanonicalHostName()) != null) {
            if (string == null) {
                string = socketPermission.getCanonicalHostName();
            }
            if (string != null && ((String)object).equals(string)) {
                return true;
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setHostPort(this.getName());
        this.setActions(this.actions);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.actions = this.getActions();
        objectOutputStream.defaultWriteObject();
    }
}

