/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.util.Collection;

public class CertStore {
    private static final String CERT_STORE = "CertStore";
    private CertStoreSpi storeSpi;
    private Provider provider;
    private String type;
    private CertStoreParameters params;

    protected CertStore(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
        this.storeSpi = certStoreSpi;
        this.provider = provider;
        this.type = string;
        this.params = certStoreParameters;
    }

    public static final synchronized String getDefaultType() {
        String string = null;
        string = (String)AccessController.doPrivileged(new PrivilegedAction(null){
            private /* synthetic */ CertStore this$0;
            {
                this.this$0 = certStore;
            }

            public Object run() {
                return Security.getProperty("certstore.type");
            }
        });
        if (string == null) {
            string = "LDAP";
        }
        return string;
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return CertStore.getInstance(string, certStoreParameters, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, String string2) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return CertStore.getInstance(string, certStoreParameters, provider);
    }

    public static CertStore getInstance(String string, CertStoreParameters certStoreParameters, Provider provider) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("null provider");
        }
        try {
            return new CertStore((CertStoreSpi)Engine.getInstance(CERT_STORE, string, provider, new Object[]{certStoreParameters}), provider, string, certStoreParameters);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)throwable;
            }
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final String getType() {
        return this.type;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertStoreParameters getCertStoreParameters() {
        if (this.params != null) {
            return (CertStoreParameters)this.params.clone();
        }
        return null;
    }

    public final Collection getCertificates(CertSelector certSelector) throws CertStoreException {
        return this.storeSpi.engineGetCertificates(certSelector);
    }

    public final Collection getCRLs(CRLSelector cRLSelector) throws CertStoreException {
        return this.storeSpi.engineGetCRLs(cRLSelector);
    }
}

