/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.text.AttributedFormatBuffer;
import gnu.java.text.FormatBuffer;
import gnu.java.text.FormatCharacterIterator;
import gnu.java.text.StringFormatBuffer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleDateFormat
extends DateFormat {
    private transient ArrayList tokens;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCentury;
    private String pattern;
    private int serialVersionOnStream;
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String standardChars = "GyMdkHmsSEDFwWahKzYeugAZ";

    private /* synthetic */ void finit$() {
        this.serialVersionOnStream = 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.computeCenturyStart();
            this.serialVersionOnStream = 1;
        } else {
            this.set2DigitYearStart(this.defaultCenturyStart);
        }
        this.tokens = new ArrayList();
        try {
            this.compileFormat(this.pattern);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException("The stream pattern was invalid.");
        }
    }

    private void compileFormat(String string) {
        CompiledField compiledField = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = standardChars.indexOf(c);
            if (n == -1) {
                compiledField = null;
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    throw new IllegalArgumentException("Invalid letter " + c + " encountered at character " + i + ".");
                }
                if (c == '\'') {
                    int n2 = string.indexOf(39, i + 1);
                    if (n2 == i + 1) {
                        this.tokens.add("'");
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n3 = i + 1;
                        while (true) {
                            if (n2 == -1) {
                                throw new IllegalArgumentException("Quotes starting at character " + i + " not closed.");
                            }
                            stringBuffer.append(string.substring(n3, n2));
                            if (n2 + 1 >= string.length() || string.charAt(n2 + 1) != '\'') break;
                            stringBuffer.append('\'');
                            n3 = n2 + 2;
                            n2 = string.indexOf(39, n2 + 2);
                        }
                        this.tokens.add(stringBuffer.toString());
                    }
                    i = n2;
                    continue;
                }
                this.tokens.add(new Character(c));
                continue;
            }
            if (compiledField != null && n == compiledField.field) {
                ++compiledField.size;
                continue;
            }
            compiledField = new CompiledField(this, n, 1, c);
            this.tokens.add(compiledField);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[tokens=");
        stringBuffer.append(this.tokens);
        stringBuffer.append(", formatData=");
        stringBuffer.append(this.formatData);
        stringBuffer.append(", defaultCenturyStart=");
        stringBuffer.append(this.defaultCenturyStart);
        stringBuffer.append(", defaultCentury=");
        stringBuffer.append(this.defaultCentury);
        stringBuffer.append(", pattern=");
        stringBuffer.append(this.pattern);
        stringBuffer.append(", serialVersionOnStream=");
        stringBuffer.append(this.serialVersionOnStream);
        stringBuffer.append(", standardChars=");
        stringBuffer.append(standardChars);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public SimpleDateFormat() {
        this.finit$();
        Locale locale = Locale.getDefault();
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.pattern = this.formatData.dateFormats[2] + ' ' + this.formatData.timeFormats[2];
        this.compileFormat(this.pattern);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.finit$();
        this.calendar = new GregorianCalendar(locale);
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        this.formatData = new DateFormatSymbols(locale);
        this.compileFormat(string);
        this.pattern = string;
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.finit$();
        this.calendar = new GregorianCalendar();
        this.computeCenturyStart();
        this.tokens = new ArrayList();
        if (dateFormatSymbols == null) {
            throw new NullPointerException("formatData");
        }
        this.formatData = dateFormatSymbols;
        this.compileFormat(string);
        this.pattern = string;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setMaximumFractionDigits(0);
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        String string = this.formatData.getLocalPatternChars();
        return this.translateLocalizedPattern(this.pattern, standardChars, string);
    }

    public void applyPattern(String string) {
        this.tokens = new ArrayList();
        this.compileFormat(string);
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        String string2 = this.formatData.getLocalPatternChars();
        string = this.translateLocalizedPattern(string, string2, standardChars);
        this.applyPattern(string);
    }

    private String translateLocalizedPattern(String string, String string2, String string3) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (c == '\'') {
                bl ^= true;
            }
            if (!bl && (n2 = string2.indexOf(c)) >= 0) {
                c = string3.charAt(n2);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Date get2DigitYearStart() {
        return this.defaultCenturyStart;
    }

    public void set2DigitYearStart(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.clear();
        this.calendar.setTime(date);
        int n = this.calendar.get(1);
        this.defaultCentury = n - n % 100;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        if (dateFormatSymbols == null) {
            throw new NullPointerException("The supplied format data was null.");
        }
        this.formatData = dateFormatSymbols;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SimpleDateFormat)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        if (this.defaultCentury != simpleDateFormat.defaultCentury) {
            return false;
        }
        if (!this.toPattern().equals(simpleDateFormat.toPattern())) {
            return false;
        }
        return this.getDateFormatSymbols().equals(simpleDateFormat.getDateFormatSymbols());
    }

    public int hashCode() {
        return super.hashCode() ^ this.toPattern().hashCode() ^ this.defaultCentury ^ this.getDateFormatSymbols().hashCode();
    }

    private void formatWithAttribute(Date date, FormatBuffer formatBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        Iterator iterator = this.tokens.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof CompiledField) {
                CompiledField compiledField = (CompiledField)object;
                int n = formatBuffer.length();
                switch (compiledField.getField()) {
                    case 0: {
                        formatBuffer.append(this.formatData.eras[this.calendar.get(0)], (AttributedCharacterIterator.Attribute)DateFormat.Field.ERA);
                        break;
                    }
                    case 1: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.YEAR);
                        if (compiledField.getSize() == 2) {
                            String string = "00" + String.valueOf(this.calendar.get(1));
                            formatBuffer.append(string.substring(string.length() - 2));
                            break;
                        }
                        this.withLeadingZeros(this.calendar.get(1), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 2: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.MONTH);
                        if (compiledField.getSize() < 3) {
                            this.withLeadingZeros(this.calendar.get(2) + 1, compiledField.getSize(), formatBuffer);
                            break;
                        }
                        if (compiledField.getSize() < 4) {
                            formatBuffer.append(this.formatData.shortMonths[this.calendar.get(2)]);
                            break;
                        }
                        formatBuffer.append(this.formatData.months[this.calendar.get(2)]);
                        break;
                    }
                    case 3: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(5), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 4: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY1);
                        this.withLeadingZeros((this.calendar.get(11) + 23) % 24 + 1, compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 5: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR_OF_DAY0);
                        this.withLeadingZeros(this.calendar.get(11), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 6: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.MINUTE);
                        this.withLeadingZeros(this.calendar.get(12), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 7: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.SECOND);
                        this.withLeadingZeros(this.calendar.get(13), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 8: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.MILLISECOND);
                        this.withLeadingZeros(this.calendar.get(14), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 9: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK);
                        if (compiledField.getSize() < 4) {
                            formatBuffer.append(this.formatData.shortWeekdays[this.calendar.get(7)]);
                            break;
                        }
                        formatBuffer.append(this.formatData.weekdays[this.calendar.get(7)]);
                        break;
                    }
                    case 10: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(6), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 11: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
                        this.withLeadingZeros(this.calendar.get(8), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 12: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_YEAR);
                        this.withLeadingZeros(this.calendar.get(3), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 13: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.WEEK_OF_MONTH);
                        this.withLeadingZeros(this.calendar.get(4), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 14: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.AM_PM);
                        formatBuffer.append(this.formatData.ampms[this.calendar.get(9)]);
                        break;
                    }
                    case 15: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR1);
                        this.withLeadingZeros((this.calendar.get(10) + 11) % 12 + 1, compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 16: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.HOUR0);
                        this.withLeadingZeros(this.calendar.get(10), compiledField.getSize(), formatBuffer);
                        break;
                    }
                    case 17: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.TIME_ZONE);
                        TimeZone timeZone = this.calendar.getTimeZone();
                        boolean bl = this.calendar.get(16) != 0;
                        String string = timeZone.getDisplayName(bl, compiledField.getSize() > 3 ? 1 : 0);
                        formatBuffer.append(string);
                        break;
                    }
                    case 23: {
                        formatBuffer.setDefaultAttribute(DateFormat.Field.RFC822_TIME_ZONE);
                        int n2 = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
                        String string = n2 < 0 ? "-" : "+";
                        n2 = Math.abs(n2);
                        int n3 = n2 / 60;
                        int n4 = n2 % 60;
                        formatBuffer.append(string);
                        this.withLeadingZeros(n3, 2, formatBuffer);
                        this.withLeadingZeros(n4, 2, formatBuffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal pattern character " + compiledField.getCharacter());
                    }
                }
                if (fieldPosition == null || formatBuffer.getDefaultAttribute() != fieldPosition.getFieldAttribute() && compiledField.getField() != fieldPosition.getField()) continue;
                fieldPosition.setBeginIndex(n);
                fieldPosition.setEndIndex(formatBuffer.length());
                continue;
            }
            formatBuffer.append(object.toString(), null);
        }
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.formatWithAttribute(date, new StringFormatBuffer(stringBuffer), fieldPosition);
        return stringBuffer;
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new NullPointerException("null argument");
        }
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("argument should be an instance of java.util.Date");
        }
        AttributedFormatBuffer attributedFormatBuffer = new AttributedFormatBuffer();
        this.formatWithAttribute((Date)object, attributedFormatBuffer, null);
        attributedFormatBuffer.sync();
        return new FormatCharacterIterator(attributedFormatBuffer.getBuffer().toString(), attributedFormatBuffer.getRanges(), attributedFormatBuffer.getAttributes());
    }

    private void withLeadingZeros(int n, int n2, FormatBuffer formatBuffer) {
        String string = String.valueOf(n);
        n2 -= string.length();
        while (n2 > 0) {
            formatBuffer.append('0');
            --n2;
        }
        formatBuffer.append(string);
    }

    private boolean expect(String string, ParsePosition parsePosition, char c) {
        boolean bl;
        int n = parsePosition.getIndex();
        boolean bl2 = bl = n < string.length() && string.charAt(n) == c;
        if (bl) {
            parsePosition.setIndex(n + 1);
        } else {
            parsePosition.setErrorIndex(n);
        }
        return bl;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n = this.pattern.length();
        this.calendar.clear();
        boolean bl = false;
        int n2 = -1;
        boolean bl2 = false;
        try {
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4;
                int number;
                int n5;
                int n6;
                int n7;
                char c = this.pattern.charAt(i);
                if (c == '\'') {
                    n7 = parsePosition.getIndex();
                    if (i < n - 1 && this.pattern.charAt(i + 1) == '\'') {
                        if (!this.expect(string, parsePosition, c)) {
                            return null;
                        }
                        ++i;
                        continue;
                    }
                    n2 = n2 < 0 ? i : -1;
                    continue;
                }
                if (n2 != -1 || (c < 'a' || c > 'z') && (c < 'A' || c > 'Z')) {
                    if (this.expect(string, parsePosition, c)) continue;
                    return null;
                }
                n7 = 1;
                while (++i < n && this.pattern.charAt(i) == c) {
                    ++n7;
                }
                boolean bl3 = false;
                if (i < n && standardChars.indexOf(this.pattern.charAt(i)) >= 0) {
                    bl3 = true;
                }
                --i;
                boolean bl4 = true;
                int n8 = 0;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                String[] stringArray = null;
                String[] stringArray2 = null;
                switch (c) {
                    case 'd': {
                        n6 = 5;
                        break;
                    }
                    case 'D': {
                        n6 = 6;
                        break;
                    }
                    case 'F': {
                        n6 = 8;
                        break;
                    }
                    case 'E': {
                        bl4 = false;
                        n8 = 1;
                        n6 = 7;
                        stringArray = this.formatData.getWeekdays();
                        stringArray2 = this.formatData.getShortWeekdays();
                        break;
                    }
                    case 'w': {
                        n6 = 3;
                        break;
                    }
                    case 'W': {
                        n6 = 4;
                        break;
                    }
                    case 'M': {
                        n6 = 2;
                        if (n7 <= 2) {
                            n8 = -1;
                            break;
                        }
                        bl4 = false;
                        stringArray = this.formatData.getMonths();
                        stringArray2 = this.formatData.getShortMonths();
                        break;
                    }
                    case 'y': {
                        n6 = 1;
                        if (n7 > 2) break;
                        bl5 = true;
                        break;
                    }
                    case 'K': {
                        n6 = 10;
                        break;
                    }
                    case 'h': {
                        n6 = 10;
                        bl6 = true;
                        break;
                    }
                    case 'H': {
                        n6 = 11;
                        break;
                    }
                    case 'k': {
                        n6 = 11;
                        bl7 = true;
                        break;
                    }
                    case 'm': {
                        n6 = 12;
                        break;
                    }
                    case 's': {
                        n6 = 13;
                        break;
                    }
                    case 'S': {
                        n6 = 14;
                        break;
                    }
                    case 'a': {
                        bl4 = false;
                        n6 = 9;
                        stringArray = this.formatData.getAmPmStrings();
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        bl4 = false;
                        n6 = 15;
                        String[][] stringArray3 = this.formatData.getZoneStrings();
                        n5 = stringArray3.length;
                        number = parsePosition.getIndex();
                        n4 = 0;
                        Integer n9 = this.computeOffset(string.substring(number), parsePosition);
                        if (n9 != null) {
                            n4 = 1;
                            bl = true;
                            this.calendar.set(16, 0);
                            n8 = n9;
                        } else {
                            for (int j = 0; j < n5; ++j) {
                                int n10;
                                String[] stringArray4 = stringArray3[j];
                                for (n10 = 0; n10 < stringArray4.length && !string.startsWith(stringArray4[n10], number); ++n10) {
                                }
                                if (n10 == stringArray4.length) continue;
                                n4 = 1;
                                bl = true;
                                TimeZone timeZone = TimeZone.getTimeZone(stringArray4[0]);
                                if (n10 == 3 || n10 == 4) {
                                    this.calendar.set(16, timeZone.getDSTSavings());
                                } else {
                                    this.calendar.set(16, 0);
                                }
                                n8 = timeZone.getRawOffset();
                                parsePosition.setIndex(number + stringArray4[n10].length());
                                break;
                            }
                        }
                        if (n4 != 0) break;
                        parsePosition.setErrorIndex(parsePosition.getIndex());
                        return null;
                    }
                    default: {
                        parsePosition.setErrorIndex(parsePosition.getIndex());
                        return null;
                    }
                }
                int stringArray3 = -1;
                if (bl4) {
                    this.numberFormat.setMinimumIntegerDigits(n7);
                    if (bl3) {
                        this.numberFormat.setMaximumIntegerDigits(n7);
                    }
                    if (bl5) {
                        stringArray3 = parsePosition.getIndex();
                    }
                    Number n32 = this.numberFormat.parse(string, parsePosition);
                    if (parsePosition == null || !(n32 instanceof Long)) {
                        return null;
                    }
                    n5 = n32.intValue() + n8;
                } else if (stringArray != null) {
                    stringArray3 = parsePosition.getIndex();
                    number = 0;
                    for (n4 = n8; n4 < stringArray.length; ++n4) {
                        if (stringArray[n4] == null || !string.toUpperCase().startsWith(stringArray[n4].toUpperCase(), stringArray3)) continue;
                        number = 1;
                        parsePosition.setIndex(stringArray3 + stringArray[n4].length());
                        break;
                    }
                    if (number == 0 && stringArray2 != null) {
                        for (n4 = n8; n4 < stringArray2.length; ++n4) {
                            if (stringArray2[n4] == null || !string.toUpperCase().startsWith(stringArray2[n4].toUpperCase(), stringArray3)) continue;
                            number = 1;
                            parsePosition.setIndex(stringArray3 + stringArray2[n4].length());
                            break;
                        }
                    }
                    if (number == 0) {
                        parsePosition.setErrorIndex(stringArray3);
                        return null;
                    }
                    n5 = n4;
                } else {
                    n5 = n8;
                }
                if (bl5 && (n3 = parsePosition.getIndex() - stringArray3) == 2) {
                    bl2 = true;
                    n5 += this.defaultCentury;
                }
                if (bl6 && n5 == 12) {
                    n5 = 0;
                }
                if (bl7 && n5 == 24) {
                    n5 = 0;
                }
                this.calendar.set(n6, n5);
            }
            if (bl2) {
                int illegalArgumentException = this.calendar.get(1);
                if (this.calendar.getTime().compareTo(this.defaultCenturyStart) < 0) {
                    this.calendar.set(1, illegalArgumentException + 100);
                }
            }
            if (!bl) {
                this.calendar.clear(16);
                this.calendar.clear(15);
            }
            return this.calendar.getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
    }

    private Integer computeOffset(String string, ParsePosition parsePosition) {
        Pattern pattern2 = Pattern.compile("(GMT)?([+-])([012])?([0-9]):?([0-9]{2})");
        Matcher matcher = pattern2.matcher(string);
        boolean bl = matcher.lookingAt();
        try {
            matcher.group(2);
            matcher.group(4);
            matcher.group(5);
        }
        catch (IllegalStateException illegalStateException) {
            bl = false;
        }
        if (bl) {
            int n = matcher.group(2).equals("+") ? 1 : -1;
            int n2 = Integer.parseInt(matcher.group(4));
            if (!matcher.group(3).equals("")) {
                n2 += Integer.parseInt(matcher.group(3)) * 10;
            }
            int n3 = Integer.parseInt(matcher.group(5));
            if (n2 > 23) {
                return null;
            }
            int n4 = n * (n2 * 60 + n3) * 60000;
            parsePosition.setIndex(parsePosition.getIndex() + matcher.end());
            return new Integer(n4);
        }
        if (string.startsWith("GMT")) {
            parsePosition.setIndex(parsePosition.getIndex() + 3);
            return new Integer(0);
        }
        return null;
    }

    private void computeCenturyStart() {
        int n = this.calendar.get(1);
        this.calendar.set(1, n - 80);
        this.set2DigitYearStart(this.calendar.getTime());
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.setDateFormatSymbols((DateFormatSymbols)this.formatData.clone());
        simpleDateFormat.set2DigitYearStart((Date)this.defaultCenturyStart.clone());
        return simpleDateFormat;
    }

    private class CompiledField {
        private /* synthetic */ SimpleDateFormat this$0;
        int field;
        int size;
        private char character;

        public CompiledField(SimpleDateFormat simpleDateFormat, int n, int n2, char c) {
            this.this$0 = simpleDateFormat;
            this.field = n;
            this.size = n2;
            this.character = c;
        }

        public int getField() {
            return this.field;
        }

        public int getSize() {
            return this.size;
        }

        public char getCharacter() {
            return this.character;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            stringBuffer.append("[field=");
            stringBuffer.append(this.field);
            stringBuffer.append(", size=");
            stringBuffer.append(this.size);
            stringBuffer.append(", character=");
            stringBuffer.append(this.character);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

