/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE);
    public static final Level SEVERE = new Level("SEVERE", 1000);
    public static final Level WARNING = new Level("WARNING", 900);
    public static final Level INFO = new Level("INFO", 800);
    public static final Level CONFIG = new Level("CONFIG", 700);
    public static final Level FINE = new Level("FINE", 500);
    public static final Level FINER = new Level("FINER", 400);
    public static final Level FINEST = new Level("FINEST", 300);
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE);
    private static final Level[] knownLevels = new Level[]{ALL, FINEST, FINER, FINE, CONFIG, INFO, WARNING, SEVERE, OFF};
    private String name;
    private int value;
    private String resourceBundleName;
    static final long serialVersionUID = -8176160795706313070L;

    protected Level(String string, int n) {
        this(string, n, null);
    }

    protected Level(String string, int n, String string2) {
        this.name = string;
        this.value = n;
        this.resourceBundleName = string2;
    }

    private Object readResolve() {
        for (int i = 0; i < knownLevels.length; ++i) {
            if (this.value != knownLevels[i].intValue()) continue;
            return knownLevels[i];
        }
        return this;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        String string = null;
        if (this.resourceBundleName != null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
                string = resourceBundle.getString(this.name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null) {
            return string;
        }
        return this.name;
    }

    public final String toString() {
        return this.getName();
    }

    public final int intValue() {
        return this.value;
    }

    public static Level parse(String string) throws IllegalArgumentException {
        int n;
        string = string.intern();
        for (n = 0; n < knownLevels.length; ++n) {
            if (string != Level.knownLevels[n].name) continue;
            return knownLevels[n];
        }
        try {
            n = Integer.parseInt(string);
            for (int i = 0; i < knownLevels.length; ++i) {
                if (n != Level.knownLevels[i].value) continue;
                return knownLevels[i];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string2 = "Not the name of a standard logging level: \"" + string + "\"";
        throw new IllegalArgumentException(string2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Level)) {
            return false;
        }
        return this.value == ((Level)object).value;
    }

    public int hashCode() {
        return this.value;
    }

    final boolean isStandardLevel() {
        for (int i = 0; i < knownLevels.length; ++i) {
            if (knownLevels[i] != this) continue;
            return true;
        }
        return false;
    }
}

