/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class MemoryHandler
extends Handler {
    private final LogRecord[] buffer;
    private int position;
    private int numPublished;
    private Level pushLevel;
    private final Handler target;

    public MemoryHandler() {
        this((Handler)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.target", MemoryHandler.class$("java.util.logging.Handler"), null), LogManager.getIntPropertyClamped("java.util.logging.MemoryHandler.size", 1000, 1, Integer.MAX_VALUE), LogManager.getLevelProperty("java.util.logging.MemoryHandler.push", Level.SEVERE));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MemoryHandler(Handler handler, int n, Level level) {
        if (handler == null || n <= 0 || level == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = new LogRecord[n];
        this.pushLevel = level;
        this.target = handler;
        this.setLevel(LogManager.getLevelProperty("java.util.logging.MemoryHandler.level", Level.ALL));
        this.setFilter((Filter)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.filter", MemoryHandler.class$("java.util.logging.Filter"), null));
    }

    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        this.buffer[this.position] = logRecord;
        this.position = (this.position + 1) % this.buffer.length;
        ++this.numPublished;
        if (logRecord.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public void push() {
        if (this.numPublished < this.buffer.length) {
            for (int i = 0; i < this.position; ++i) {
                this.target.publish(this.buffer[i]);
            }
        } else {
            int n;
            for (n = this.position; n < this.buffer.length; ++n) {
                this.target.publish(this.buffer[n]);
            }
            for (n = 0; n < this.position; ++n) {
                this.target.publish(this.buffer[n]);
            }
        }
        this.numPublished = 0;
        this.position = 0;
    }

    public void flush() {
        this.target.flush();
    }

    public void close() throws SecurityException {
        this.push();
        this.target.close();
    }

    public Level getPushLevel() {
        return this.pushLevel;
    }

    public void setPushLevel(Level level) {
        LogManager.getLogManager().checkAccess();
        level.getClass();
        this.pushLevel = level;
    }
}

