/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.ExemptionMechanismSpi;
import javax.crypto.ShortBufferException;

public class ExemptionMechanism {
    private static final String SERVICE = "ExemptionMechanism";
    private ExemptionMechanismSpi emSpi;
    private Provider provider;
    private String mechanism;
    private boolean virgin;

    protected ExemptionMechanism(ExemptionMechanismSpi exemptionMechanismSpi, Provider provider, String string) {
        this.emSpi = exemptionMechanismSpi;
        this.provider = provider;
        this.mechanism = string;
        this.virgin = true;
    }

    public static final ExemptionMechanism getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        String string2 = "";
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return ExemptionMechanism.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string2 = noSuchAlgorithmException.getMessage();
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string2);
    }

    public static final ExemptionMechanism getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return ExemptionMechanism.getInstance(string, provider);
    }

    public static final ExemptionMechanism getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new ExemptionMechanism((ExemptionMechanismSpi)Engine.getInstance(SERVICE, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)invocationTargetException.getCause();
            }
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final byte[] genExemptionBlob() throws IllegalStateException, ExemptionMechanismException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGenExemptionBlob();
    }

    public final int genExemptionBlob(byte[] byArray) throws IllegalStateException, ExemptionMechanismException, ShortBufferException {
        return this.genExemptionBlob(byArray, 0);
    }

    public final int genExemptionBlob(byte[] byArray, int n) throws IllegalStateException, ExemptionMechanismException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGenExemptionBlob(byArray, n);
    }

    public final String getName() {
        return this.mechanism;
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        return this.emSpi.engineGetOutputSize(n);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws ExemptionMechanismException, InvalidKeyException {
        this.emSpi.engineInit(key);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameters algorithmParameters) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.emSpi.engineInit(key, algorithmParameters);
        this.virgin = false;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.emSpi.engineInit(key, algorithmParameterSpec);
        this.virgin = false;
    }

    public final boolean isCryptoAllowed(Key key) throws ExemptionMechanismException {
        return true;
    }

    protected void finalize() {
    }
}

